/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.gcs;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import io.camunda.zeebe.backup.api.Backup;
import io.camunda.zeebe.backup.api.BackupIdentifier;
import io.camunda.zeebe.backup.api.BackupIdentifierWildcard;
import io.camunda.zeebe.backup.common.BackupStoreException;
import io.camunda.zeebe.backup.common.Manifest;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class ManifestManager {
    public static final String ERROR_MSG_MANIFEST_ALREADY_EXISTS = "Expected to create new manifest for backup '%s', but already exists.";
    public static final String ERROR_MSG_MANIFEST_MODIFICATION = "Expected to complete manifest for backup '%s', but modification was detected unexpectedly.";
    public static final ObjectMapper MAPPER = new ObjectMapper().registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule()).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
    public static final int PRECONDITION_FAILED = 412;
    private static final String MANIFESTS_ROOT_PATH_FORMAT = "%smanifests/";
    private static final String MANIFEST_PATH_FORMAT = "%smanifests/%s/%s/%s/%s";
    private static final String MANIFEST_BLOB_NAME = "manifest.json";
    private final BucketInfo bucketInfo;
    private final Storage client;
    private final String basePath;

    ManifestManager(Storage client, BucketInfo bucketInfo, String basePath) {
        this.bucketInfo = bucketInfo;
        this.client = client;
        this.basePath = basePath;
    }

    PersistedManifest createInitialManifest(Backup backup) {
        BlobInfo manifestBlobInfo = this.manifestBlobInfo(backup.id());
        Manifest.InProgressManifest manifest = Manifest.createInProgress((Backup)backup);
        try {
            Blob blob = this.client.create(manifestBlobInfo, MAPPER.writeValueAsBytes((Object)manifest), new Storage.BlobTargetOption[]{Storage.BlobTargetOption.doesNotExist()});
            return new PersistedManifest(blob.getGeneration(), manifest);
        }
        catch (StorageException e) {
            if (e.getCode() == 412) {
                throw new BackupStoreException.UnexpectedManifestState(ERROR_MSG_MANIFEST_ALREADY_EXISTS.formatted(backup.id()));
            }
            throw e;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    void completeManifest(PersistedManifest persistedManifest) {
        Long generation = persistedManifest.generation();
        Manifest.CompletedManifest completed = persistedManifest.manifest().complete();
        try {
            this.client.create(this.manifestBlobInfo((BackupIdentifier)completed.id()), MAPPER.writeValueAsBytes((Object)completed), new Storage.BlobTargetOption[]{Storage.BlobTargetOption.generationMatch((long)generation)});
        }
        catch (StorageException e) {
            if (e.getCode() == 412) {
                throw new BackupStoreException.UnexpectedManifestState(ERROR_MSG_MANIFEST_MODIFICATION.formatted(completed.id()));
            }
            throw e;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    Manifest getManifest(BackupIdentifier id) {
        Blob blob = this.client.get(this.manifestBlobInfo(id).getBlobId());
        if (blob == null) {
            return null;
        }
        try {
            return (Manifest)MAPPER.readValue(blob.getContent(new Blob.BlobSourceOption[0]), Manifest.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    void markAsFailed(BackupIdentifier id, String failureReason) {
        BlobInfo blobInfo = this.manifestBlobInfo(id);
        Blob blob = this.client.get(blobInfo.getBlobId());
        try {
            if (blob == null) {
                Manifest.FailedManifest failed = Manifest.createFailed((BackupIdentifier)id);
                this.client.create(blobInfo, MAPPER.writeValueAsBytes((Object)failed), new Storage.BlobTargetOption[]{Storage.BlobTargetOption.doesNotExist()});
            } else {
                Manifest existingManifest = (Manifest)MAPPER.readValue(blob.getContent(new Blob.BlobSourceOption[0]), Manifest.class);
                this.markAsFailed(existingManifest, failureReason);
            }
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    void markAsFailed(Manifest existingManifest, String failureReason) {
        Manifest.FailedManifest updatedManifest;
        switch (existingManifest.statusCode()) {
            default: {
                throw new MatchException(null, null);
            }
            case FAILED: {
                Manifest.FailedManifest failedManifest = existingManifest.asFailed();
                break;
            }
            case COMPLETED: {
                Manifest.FailedManifest failedManifest = existingManifest.asCompleted().fail(failureReason);
                break;
            }
            case IN_PROGRESS: {
                Manifest.FailedManifest failedManifest = updatedManifest = existingManifest.asInProgress().fail(failureReason);
            }
        }
        if (existingManifest != updatedManifest) {
            try {
                this.client.create(this.manifestBlobInfo((BackupIdentifier)existingManifest.id()), MAPPER.writeValueAsBytes((Object)updatedManifest), new Storage.BlobTargetOption[0]);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Collection<Manifest> listManifests(BackupIdentifierWildcard wildcard) {
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(this.client.list(this.bucketInfo.getName(), new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)this.wildcardPrefix(wildcard))}).iterateAll().iterator(), 1024);
        return ((Stream)StreamSupport.stream(spliterator, false).filter(this.filterBlobsByWildcard(wildcard)).parallel()).map(rec$ -> ((Blob)rec$).getContent(new Blob.BlobSourceOption[0])).map(content -> {
            try {
                return (Manifest)MAPPER.readValue(content, Manifest.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).toList();
    }

    public void deleteManifest(BackupIdentifier id) {
        this.client.delete(this.manifestBlobInfo(id).getBlobId());
    }

    private BlobInfo manifestBlobInfo(BackupIdentifier id) {
        String blobName = MANIFEST_PATH_FORMAT.formatted(this.basePath, id.partitionId(), id.checkpointId(), id.nodeId(), MANIFEST_BLOB_NAME);
        return BlobInfo.newBuilder((BucketInfo)this.bucketInfo, (String)blobName).setContentType("application/json").build();
    }

    private String wildcardPrefix(BackupIdentifierWildcard wildcard) {
        return MANIFESTS_ROOT_PATH_FORMAT.formatted(this.basePath) + BackupIdentifierWildcard.asPrefix((BackupIdentifierWildcard)wildcard);
    }

    private Predicate<Blob> filterBlobsByWildcard(BackupIdentifierWildcard wildcard) {
        Predicate<String> pattern = Pattern.compile(MANIFEST_PATH_FORMAT.formatted(Pattern.quote(this.basePath), wildcard.partitionId().map(Object::toString).orElse("\\d+"), wildcard.checkpointPattern().asRegex(), wildcard.nodeId().map(Object::toString).orElse("\\d+"), Pattern.quote(MANIFEST_BLOB_NAME))).asMatchPredicate();
        return blob -> pattern.test(blob.getName());
    }

    record PersistedManifest(Long generation, Manifest.InProgressManifest manifest) {
    }
}

