/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.gcs;

import io.camunda.zeebe.backup.gcs.GcsBackupStoreException;
import io.camunda.zeebe.backup.gcs.GcsConnectionConfig;
import java.util.Objects;

public record GcsBackupConfig(String bucketName, String basePath, GcsConnectionConfig connection) {
    public GcsBackupConfig(String bucketName, String basePath, GcsConnectionConfig connection) {
        this.bucketName = GcsBackupConfig.requireBucketName(bucketName);
        this.basePath = GcsBackupConfig.sanitizeBasePath(basePath);
        this.connection = Objects.requireNonNull(connection);
    }

    private static String requireBucketName(String bucketName) {
        if (bucketName == null || bucketName.isBlank()) {
            throw new GcsBackupStoreException.ConfigurationException("bucketName must be provided");
        }
        return bucketName;
    }

    private static String sanitizeBasePath(String basePath) {
        if (basePath == null) {
            return null;
        }
        String sanitized = basePath.trim();
        if (sanitized.isEmpty() || sanitized.equals("/")) {
            return null;
        }
        while (sanitized.startsWith("/")) {
            sanitized = sanitized.substring(1);
        }
        while (sanitized.endsWith("/")) {
            sanitized = sanitized.substring(0, sanitized.length() - 1);
        }
        if (sanitized.isBlank()) {
            throw new GcsBackupStoreException.ConfigurationException("After removing leading and trailing '/' characters from basePath '%s', the remainder is empty and not a valid base path".formatted(basePath));
        }
        return sanitized;
    }

    public static final class Builder {
        private String bucketName;
        private String basePath;
        private String host;
        private GcsConnectionConfig.Authentication auth;

        public Builder withBucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder withBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public Builder withHost(String host) {
            this.host = host;
            return this;
        }

        public Builder withoutAuthentication() {
            this.auth = new GcsConnectionConfig.Authentication.None("tmp");
            return this;
        }

        public Builder withAutoAuthentication() {
            this.auth = new GcsConnectionConfig.Authentication.Auto();
            return this;
        }

        public GcsBackupConfig build() {
            return new GcsBackupConfig(this.bucketName, this.basePath, new GcsConnectionConfig(this.host, this.auth));
        }
    }
}

