/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.gcs.manifest;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.camunda.zeebe.backup.api.Backup;
import io.camunda.zeebe.backup.api.BackupDescriptor;
import io.camunda.zeebe.backup.api.BackupIdentifier;
import io.camunda.zeebe.backup.common.BackupDescriptorImpl;
import io.camunda.zeebe.backup.common.BackupIdentifierImpl;
import io.camunda.zeebe.backup.gcs.manifest.FileSet;
import io.camunda.zeebe.backup.gcs.manifest.ManifestImpl;
import java.time.Instant;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@JsonSerialize(as=ManifestImpl.class)
@JsonDeserialize(as=ManifestImpl.class)
public interface Manifest {
    public static InProgressManifest createInProgress(Backup backup) {
        Instant creationTime = Instant.now();
        return new ManifestImpl(BackupIdentifierImpl.from((BackupIdentifier)backup.id()), BackupDescriptorImpl.from((BackupDescriptor)backup.descriptor()), StatusCode.IN_PROGRESS, FileSet.of(backup.snapshot()), FileSet.of(backup.segments()), creationTime, creationTime);
    }

    public static FailedManifest createFailed(BackupIdentifier id) {
        Instant creationTime = Instant.now();
        return new ManifestImpl(BackupIdentifierImpl.from((BackupIdentifier)id), null, StatusCode.FAILED, null, null, creationTime, creationTime);
    }

    public BackupIdentifierImpl id();

    public BackupDescriptorImpl descriptor();

    public StatusCode statusCode();

    public Instant createdAt();

    public Instant modifiedAt();

    public InProgressManifest asInProgress();

    public CompletedManifest asCompleted();

    public FailedManifest asFailed();

    public static enum StatusCode {
        IN_PROGRESS,
        COMPLETED,
        FAILED;

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface FailedManifest
    extends Manifest {
        public String failureReason();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface CompletedManifest
    extends Manifest {
        public FailedManifest fail(String var1);

        public FileSet snapshot();

        public FileSet segments();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface InProgressManifest
    extends Manifest {
        public CompletedManifest complete();

        public FailedManifest fail(String var1);
    }
}

