/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.filesystem;

import io.camunda.zeebe.backup.api.BackupIdentifier;
import io.camunda.zeebe.backup.api.NamedFileSet;
import io.camunda.zeebe.backup.common.FileSet;
import io.camunda.zeebe.backup.common.NamedFileSetImpl;
import io.camunda.zeebe.util.FileUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FileSetManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSetManager.class);
    private static final String PATH_FORMAT = "%s/contents/%s/%s/%s/%s/";
    private final String basePath;

    FileSetManager(String basePath) {
        this.basePath = basePath;
    }

    void save(BackupIdentifier id, String fileSetName, NamedFileSet fileSet) {
        Path fileSetPath = this.fileSetPath(id, fileSetName);
        try {
            FileUtil.ensureDirectoryExists((Path)fileSetPath);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to create backup directory", e);
        }
        for (Map.Entry namedFile : fileSet.namedFiles().entrySet()) {
            String sourceFileName = (String)namedFile.getKey();
            Path sourceFilePath = (Path)namedFile.getValue();
            Path targetFilePath = fileSetPath.resolve(sourceFileName);
            try {
                Files.copy(sourceFilePath, targetFilePath, new CopyOption[0]);
                FileUtil.flush((Path)targetFilePath);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to copy file " + String.valueOf(sourceFilePath), e);
            }
        }
        try {
            FileUtil.flushDirectory((Path)fileSetPath);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to flush directory " + String.valueOf(fileSetPath) + " data might not be consistent on the filesystem. Backup should be restarted.", e);
        }
    }

    public void delete(BackupIdentifier id, String fileSetName) {
        Path fileSetPath = this.fileSetPath(id, fileSetName);
        try {
            FileUtil.deleteFolder((Path)fileSetPath);
            FileUtil.flushDirectory((Path)fileSetPath.getParent());
        }
        catch (NoSuchFileException e) {
            LOGGER.warn("Try to remove unknown fileset {} in backup {}", (Object)fileSetName, (Object)id);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to delete directory " + String.valueOf(fileSetPath), e);
        }
    }

    public NamedFileSet restore(BackupIdentifier id, String fileSetName, FileSet fileSet, Path targetFolder) {
        Map<String, Path> pathByName = fileSet.files().stream().collect(Collectors.toMap(FileSet.NamedFile::name, f -> targetFolder.resolve(f.name())));
        Path fileSetPath = this.fileSetPath(id, fileSetName);
        for (Map.Entry<String, Path> entry : pathByName.entrySet()) {
            String fileName = entry.getKey();
            Path filePath = entry.getValue();
            Path backupFilePath = fileSetPath.resolve(fileName);
            try {
                Files.copy(backupFilePath, filePath, StandardCopyOption.REPLACE_EXISTING);
                FileUtil.flush((Path)filePath);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to restore file " + fileName, e);
            }
        }
        try {
            FileUtil.flushDirectory((Path)targetFolder);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to flush directory " + String.valueOf(targetFolder) + ", the restored backup " + String.valueOf(id) + " may be incomplete and inconsistent!", e);
        }
        return new NamedFileSetImpl(pathByName);
    }

    private Path fileSetPath(BackupIdentifier id, String fileSetName) {
        return Path.of(PATH_FORMAT.formatted(this.basePath, id.partitionId(), id.checkpointId(), id.nodeId(), fileSetName), new String[0]);
    }
}

