/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.azure;

import com.azure.core.util.BinaryData;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.models.BlobErrorCode;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.azure.storage.blob.specialized.BlockBlobClient;
import io.camunda.zeebe.backup.api.BackupIdentifier;
import io.camunda.zeebe.backup.api.NamedFileSet;
import io.camunda.zeebe.backup.azure.AzureBackupStoreException;
import io.camunda.zeebe.backup.common.FileSet;
import io.camunda.zeebe.backup.common.NamedFileSetImpl;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Collectors;

final class FileSetManager {
    private static final String PATH_FORMAT = "contents/%s/%s/%s/%s/";
    private final BlobContainerClient containerClient;
    private boolean containerCreated = false;

    FileSetManager(BlobContainerClient containerClient, boolean createContainer) {
        this.containerClient = containerClient;
        this.containerCreated = !createContainer;
    }

    void save(BackupIdentifier id, String fileSetName, NamedFileSet fileSet) {
        this.assureContainerCreated();
        for (Map.Entry namedFile : fileSet.namedFiles().entrySet()) {
            String fileName = (String)namedFile.getKey();
            Path filePath = (Path)namedFile.getValue();
            String fileSetPath = this.fileSetPath(id, fileSetName);
            BlobClient blobClient = this.containerClient.getBlobClient(fileSetPath + fileName);
            try {
                BinaryData binaryData = BinaryData.fromFile((Path)filePath);
                blobClient.upload(binaryData, false);
            }
            catch (BlobStorageException e) {
                if (e.getErrorCode() == BlobErrorCode.BLOB_ALREADY_EXISTS) {
                    throw new AzureBackupStoreException.BlobAlreadyExists("File already exists.", e.getCause());
                }
                throw e;
            }
        }
    }

    public void delete(BackupIdentifier id, String fileSetName) {
        this.assureContainerCreated();
        ListBlobsOptions options = new ListBlobsOptions().setPrefix(this.fileSetPath(id, fileSetName));
        this.containerClient.listBlobs(options, null).forEach(blobItem -> this.containerClient.getBlobClient(blobItem.getName()).getBlockBlobClient().delete());
    }

    public NamedFileSet restore(BackupIdentifier id, String fileSetName, FileSet fileSet, Path targetFolder) {
        Map<String, Path> pathByName = fileSet.files().stream().collect(Collectors.toMap(FileSet.NamedFile::name, f -> targetFolder.resolve(f.name())));
        for (Map.Entry<String, Path> entry : pathByName.entrySet()) {
            String fileName = entry.getKey();
            Path filePath = entry.getValue();
            BlockBlobClient blobClient = this.containerClient.getBlobClient(this.fileSetPath(id, fileSetName) + fileName).getBlockBlobClient();
            blobClient.downloadToFile(String.valueOf(filePath), true);
        }
        return new NamedFileSetImpl(pathByName);
    }

    void assureContainerCreated() {
        if (!this.containerCreated) {
            this.containerClient.createIfNotExists();
            this.containerCreated = true;
        }
    }

    private String fileSetPath(BackupIdentifier id, String fileSetName) {
        return PATH_FORMAT.formatted(id.partitionId(), id.checkpointId(), id.nodeId(), fileSetName);
    }
}

