/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.zeebe;

import com.google.common.base.Stopwatch;
import io.atomix.raft.storage.log.IndexedRaftLogEntry;
import io.atomix.raft.zeebe.ZeebeLogAppender;
import io.atomix.raft.zeebe.util.TestAppender;
import io.atomix.raft.zeebe.util.ZeebeTestHelper;
import io.atomix.raft.zeebe.util.ZeebeTestNode;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.AutoClose;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeebeLogAppenderTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    @AutoClose
    MeterRegistry meterRegistry = new SimpleMeterRegistry();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Stopwatch stopwatch = Stopwatch.createUnstarted();
    private final TestAppender appenderListener = new TestAppender();
    private ZeebeTestNode node;
    private ZeebeTestHelper helper;

    @Before
    public void setUp() throws Exception {
        this.node = new ZeebeTestNode(0, this.temporaryFolder.newFolder("0"), this.meterRegistry);
        Set<ZeebeTestNode> nodes = Collections.singleton(this.node);
        this.helper = new ZeebeTestHelper(nodes);
        this.node.start(nodes).join();
        this.stopwatch.start();
    }

    @After
    public void tearDown() {
        if (this.stopwatch.isRunning()) {
            this.stopwatch.stop();
        }
        this.logger.info("Test run time: {}", (Object)this.stopwatch.toString());
        this.node.stop().join();
    }

    @Test
    public void shouldNotifyOnWrite() {
        this.append();
        IndexedRaftLogEntry appended = this.appenderListener.pollWritten();
        Assertions.assertThat((Object)appended).isNotNull();
        Assertions.assertThat((int)this.appenderListener.getErrors().size()).isEqualTo(0);
    }

    @Test
    public void shouldNotifyOnCommit() {
        this.append();
        Long committed = this.appenderListener.pollCommitted();
        Assertions.assertThat((Long)committed).isNotNull();
        Assertions.assertThat((int)this.appenderListener.getErrors().size()).isEqualTo(0);
    }

    @Test
    public void shouldNotifyOnError() {
        ByteBuffer data = ByteBuffer.allocate(2048);
        this.append(data);
        Throwable error = this.appenderListener.pollError();
        Assertions.assertThat((Throwable)error).isNotNull();
        Assertions.assertThat((int)this.appenderListener.getWritten().size()).isEqualTo(0L);
        Assertions.assertThat((int)this.appenderListener.getCommitted().size()).isEqualTo(0L);
    }

    private void append() {
        this.append(ByteBuffer.allocate(4).putInt(0, 1));
    }

    private void append(ByteBuffer data) {
        ZeebeLogAppender appender = this.helper.awaitLeaderAppender(1);
        appender.appendEntry(0L, 0L, data, (ZeebeLogAppender.AppendListener)this.appenderListener);
    }
}

