/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.log;

import io.atomix.raft.storage.log.IndexedRaftLogEntry;
import io.atomix.raft.storage.log.RaftLog;
import io.atomix.raft.storage.log.RaftLogReader;
import io.atomix.raft.storage.log.entry.RaftEntry;
import io.atomix.raft.storage.log.entry.RaftLogEntry;
import io.atomix.raft.storage.log.entry.SerializedApplicationEntry;
import io.camunda.zeebe.journal.JournalMetaStore;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.AutoClose;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class RaftLogCommittedReaderTest {
    private RaftLog raftlog;
    private RaftLogReader committedReader;
    @AutoClose
    private final MeterRegistry meterRegistry = new SimpleMeterRegistry();
    private final ByteBuffer data = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(123456);

    RaftLogCommittedReaderTest() {
    }

    @BeforeEach
    void setup(@TempDir File directory) {
        this.raftlog = RaftLog.builder((MeterRegistry)this.meterRegistry).withDirectory(directory).withName("test").withMetaStore((JournalMetaStore)new JournalMetaStore.InMemory()).build();
        this.committedReader = this.raftlog.openCommittedReader();
    }

    @AfterEach
    void tearDown() {
        this.committedReader.close();
        this.raftlog.close();
    }

    @Test
    void shouldReadOnlyCommittedEntries() {
        this.appendEntries(3);
        this.raftlog.setCommitIndex(2L);
        Assertions.assertThat((boolean)this.committedReader.hasNext()).isTrue();
        Assertions.assertThat((long)((IndexedRaftLogEntry)this.committedReader.next()).index()).isEqualTo(1L);
        Assertions.assertThat((boolean)this.committedReader.hasNext()).isTrue();
        Assertions.assertThat((long)((IndexedRaftLogEntry)this.committedReader.next()).index()).isEqualTo(2L);
        Assertions.assertThat((boolean)this.committedReader.hasNext()).isFalse();
    }

    @Test
    void shouldSeekToIndex() {
        this.appendEntries(10);
        this.raftlog.setCommitIndex(10L);
        long nextIndex = this.committedReader.seek(5L);
        Assertions.assertThat((long)nextIndex).isEqualTo(5L);
        Assertions.assertThat((boolean)this.committedReader.hasNext()).isTrue();
        Assertions.assertThat((long)((IndexedRaftLogEntry)this.committedReader.next()).index()).isEqualTo(5L);
    }

    @Test
    void shouldNotSeekBeyondCommittedIndex() {
        this.appendEntries(10);
        this.raftlog.setCommitIndex(4L);
        long nextIndex = this.committedReader.seek(5L);
        Assertions.assertThat((long)nextIndex).isEqualTo(5L);
        Assertions.assertThat((boolean)this.committedReader.hasNext()).isFalse();
    }

    @Test
    void shouldSeekToLastCommittedIndex() {
        this.appendEntries(10);
        this.raftlog.setCommitIndex(5L);
        long nextIndex = this.committedReader.seekToLast();
        Assertions.assertThat((long)nextIndex).isEqualTo(5L);
        Assertions.assertThat((boolean)this.committedReader.hasNext()).isTrue();
        Assertions.assertThat((long)((IndexedRaftLogEntry)this.committedReader.next()).index()).isEqualTo(5L);
    }

    @Test
    void shouldSeekToAsqnWithInCommittedIndex() {
        this.appendEntries(10);
        this.raftlog.setCommitIndex(4L);
        long nextIndex = this.committedReader.seekToAsqn(5L);
        Assertions.assertThat((long)nextIndex).isEqualTo(4L);
        Assertions.assertThat((boolean)this.committedReader.hasNext()).isTrue();
        Assertions.assertThat((long)((IndexedRaftLogEntry)this.committedReader.next()).getPersistedRaftRecord().asqn()).isEqualTo(4L);
    }

    @Test
    void shouldSeekToLastAsqnWithInCommittedIndex() {
        this.appendEntries(10);
        this.raftlog.setCommitIndex(4L);
        long nextIndex = this.committedReader.seekToAsqn(Long.MAX_VALUE);
        Assertions.assertThat((long)nextIndex).isEqualTo(4L);
        Assertions.assertThat((boolean)this.committedReader.hasNext()).isTrue();
        Assertions.assertThat((long)((IndexedRaftLogEntry)this.committedReader.next()).getPersistedRaftRecord().asqn()).isEqualTo(4L);
    }

    private void appendEntries(int count) {
        for (int i = 0; i < count; ++i) {
            SerializedApplicationEntry applicationEntry = new SerializedApplicationEntry((long)(i + 1), (long)(i + 1), this.data);
            RaftLogEntry entry = new RaftLogEntry(1L, (RaftEntry)applicationEntry);
            this.raftlog.append(entry);
        }
    }
}

