/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.roles;

import io.atomix.raft.FaultyFlusherConfigurator;
import io.atomix.raft.RaftException;
import io.atomix.raft.RaftRule;
import io.atomix.raft.RaftServer;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class RaftLeaderFlushErrorTest {
    private static final Logger LOG = LoggerFactory.getLogger(RaftLeaderFlushErrorTest.class);
    private static final int MEMBERS = 3;
    @Parameterized.Parameter
    public boolean withDataLoss;
    @Rule
    @Parameterized.Parameter(value=1)
    public RaftRule raftRule;
    @Parameterized.Parameter(value=2)
    public AtomicBoolean isFaulty;
    @Parameterized.Parameter(value=3)
    public AtomicInteger flushFailedCount;

    @Parameterized.Parameters(name="{index}: withDataLoss = {0}")
    public static Collection<Object[]> parameters() {
        return Stream.of(true, false).map(withDataLoss -> {
            AtomicBoolean isFaulty = new AtomicBoolean(false);
            AtomicInteger flushFailedCount = new AtomicInteger(0);
            Object[] objectArray = new Object[4];
            objectArray[0] = withDataLoss;
            objectArray[1] = RaftRule.withBootstrappedNodes(3, new FaultyFlusherConfigurator(1, isFaulty::get, flushFailedCount::incrementAndGet, true, (boolean)withDataLoss));
            objectArray[2] = isFaulty;
            objectArray[3] = flushFailedCount;
            return objectArray;
        }).toList();
    }

    @Test
    public void shouldTransitionToFollowerWhenLeaderFailsToFlush() throws Exception {
        RaftServer leader = this.raftRule.getLeader().get();
        Assertions.assertThat((String)leader.name()).isEqualTo("1");
        this.raftRule.appendEntry();
        this.isFaulty.set(true);
        LOG.info("Leader flusher set to faulty");
        RaftRule.TestAppendListener commitListener = this.raftRule.appendEntryAsync();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> commitListener.awaitCommit(Duration.ofSeconds(2L))).isInstanceOf(ExecutionException.class)).hasCauseInstanceOf(RaftException.AppendFailureException.class);
        this.isFaulty.set(false);
        LOG.info("Leader flusher is not faulty anymore");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> commitListener.awaitCommit(Duration.ofSeconds(2L))).isInstanceOf(ExecutionException.class)).hasCauseInstanceOf(RaftException.AppendFailureException.class);
        this.raftRule.awaitNewLeader();
        LOG.debug("appending a new entry after leader change");
        long finalIndex = this.raftRule.appendEntry();
        this.raftRule.awaitSameLogSizeOnAllNodes(finalIndex);
    }
}

