/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.roles;

import io.atomix.raft.FaultyFlusherConfigurator;
import io.atomix.raft.RaftRule;
import io.atomix.raft.RaftServer;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.awaitility.Awaitility;
import org.junit.Rule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftFollowerFlushErrorTest {
    private static final Logger LOG = LoggerFactory.getLogger(RaftFollowerFlushErrorTest.class);
    private static final int MEMBERS = 3;
    public AtomicBoolean isFaulty = new AtomicBoolean(false);
    public AtomicInteger flushFailedCount = new AtomicInteger(0);
    @Rule
    public RaftRule raftRule = RaftRule.withBootstrappedNodes(3, new FaultyFlusherConfigurator(1, this.isFaulty::get, this.flushFailedCount::incrementAndGet, false, false));

    @Test
    public void shouldAppendEntryOnAllNodesWhenFollowerFailsFlush() throws Throwable {
        RaftServer leader = this.raftRule.getLeader().get();
        boolean failingNodes = true;
        Assertions.assertThat((int)Integer.parseInt(leader.name())).isGreaterThan(1);
        long index = this.raftRule.appendEntry();
        this.raftRule.awaitSameLogSizeOnAllNodes(index);
        LOG.debug("Setting flusher to faulty");
        this.isFaulty.set(true);
        RaftRule.TestAppendListener commitListener = this.raftRule.appendEntryAsync();
        long lastIndex = commitListener.awaitCommit(Duration.ofSeconds(5L));
        Awaitility.await((String)"Flush failed for all faulty nodes at least once").until(() -> this.flushFailedCount.get() > 1);
        this.isFaulty.set(false);
        this.raftRule.awaitSameLogSizeOnAllNodes(lastIndex);
        Assertions.assertThat((int)this.raftRule.getMemberLogs().size()).isEqualTo(3);
        Awaitility.await((String)"Until all members are FOLLOWER or LEADER").untilAsserted(() -> {
            List<RaftServer.Role> roles = this.raftRule.getServers().stream().map(RaftServer::getRole).toList();
            ((ListAssert)Assertions.assertThat(roles).withFailMessage(String.format("Expected all members to be FOLLOWER or LEADER, got %s", roles), new Object[0])).allMatch(r -> r == RaftServer.Role.FOLLOWER || r == RaftServer.Role.LEADER);
        });
    }
}

