/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.roles;

import io.atomix.cluster.MemberId;
import io.atomix.raft.impl.RaftContext;
import io.atomix.raft.metrics.RaftReplicationMetrics;
import io.atomix.raft.protocol.AppendRequest;
import io.atomix.raft.protocol.AppendResponse;
import io.atomix.raft.protocol.PersistedRaftRecord;
import io.atomix.raft.protocol.ProtocolVersionHandler;
import io.atomix.raft.protocol.ReplicatableJournalRecord;
import io.atomix.raft.protocol.VersionedAppendRequest;
import io.atomix.raft.roles.PassiveRole;
import io.atomix.raft.storage.RaftStorage;
import io.atomix.raft.storage.log.IndexedRaftLogEntry;
import io.atomix.raft.storage.log.RaftLog;
import io.camunda.zeebe.journal.CheckedJournalException;
import io.camunda.zeebe.journal.JournalException;
import io.camunda.zeebe.snapshots.PersistedSnapshot;
import io.camunda.zeebe.snapshots.ReceivableSnapshotStore;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.AutoClose;
import org.junit.rules.Timeout;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class PassiveRoleTest {
    @Rule
    public Timeout timeout = new Timeout(30L, TimeUnit.SECONDS);
    private RaftLog log;
    private PassiveRole role;
    private RaftContext ctx;
    @AutoClose
    private final MeterRegistry meterRegistry = new SimpleMeterRegistry();

    @Before
    public void setup() throws IOException {
        this.ctx = (RaftContext)Mockito.mock(RaftContext.class);
        this.log = (RaftLog)Mockito.mock(RaftLog.class);
        Mockito.when((Object)this.log.flushesDirectly()).thenReturn((Object)true);
        Mockito.when((Object)this.ctx.getLog()).thenReturn((Object)this.log);
        PersistedSnapshot snapshot = (PersistedSnapshot)Mockito.mock(PersistedSnapshot.class);
        Mockito.when((Object)snapshot.getIndex()).thenReturn((Object)1L);
        Mockito.when((Object)snapshot.getTerm()).thenReturn((Object)1L);
        ReceivableSnapshotStore store = (ReceivableSnapshotStore)Mockito.mock(ReceivableSnapshotStore.class);
        Mockito.when((Object)store.getLatestSnapshot()).thenReturn(Optional.of(snapshot));
        RaftStorage storage = (RaftStorage)Mockito.mock(RaftStorage.class);
        Mockito.when((Object)this.ctx.getStorage()).thenReturn((Object)storage);
        Mockito.when((Object)this.ctx.getLog()).thenReturn((Object)this.log);
        Mockito.when((Object)this.ctx.getPersistedSnapshotStore()).thenReturn((Object)store);
        Mockito.when((Object)this.ctx.getTerm()).thenReturn((Object)1L);
        Mockito.when((Object)this.ctx.getReplicationMetrics()).thenReturn((Object)((RaftReplicationMetrics)Mockito.mock(RaftReplicationMetrics.class)));
        Mockito.when((Object)this.ctx.getMeterRegistry()).thenReturn((Object)this.meterRegistry);
        Mockito.when((Object)this.ctx.getName()).thenReturn((Object)"partition-1");
        this.role = new PassiveRole(this.ctx);
    }

    @Test
    public void shouldFailAppendWithIncorrectChecksum() {
        List<ReplicatableJournalRecord> entries = List.of(new ReplicatableJournalRecord(1L, 1L, 12345L, new byte[1]));
        VersionedAppendRequest request = VersionedAppendRequest.builder().withTerm(2L).withLeader(MemberId.anonymous()).withPrevLogTerm(0L).withPrevLogIndex(0L).withEntries(entries).withCommitIndex(1L).build();
        Mockito.when((Object)this.log.append((ReplicatableJournalRecord)ArgumentMatchers.any(ReplicatableJournalRecord.class))).thenThrow(new Throwable[]{new JournalException.InvalidChecksum("expected")});
        AppendResponse response = (AppendResponse)this.role.handleAppend(ProtocolVersionHandler.transform((VersionedAppendRequest)request)).join();
        Assertions.assertThat((boolean)response.succeeded()).isFalse();
    }

    @Test
    public void shouldFlushAfterAppendRequest() throws CheckedJournalException {
        List<ReplicatableJournalRecord> entries = List.of(new ReplicatableJournalRecord(1L, 1L, 1L, new byte[1]), new ReplicatableJournalRecord(1L, 2L, 1L, new byte[1]));
        VersionedAppendRequest request = VersionedAppendRequest.builder().withTerm(1L).withLeader(MemberId.anonymous()).withPrevLogTerm(0L).withPrevLogIndex(0L).withEntries(entries).withCommitIndex(2L).build();
        Mockito.when((Object)this.log.append((ReplicatableJournalRecord)ArgumentMatchers.any(ReplicatableJournalRecord.class))).thenReturn((Object)((IndexedRaftLogEntry)Mockito.mock(IndexedRaftLogEntry.class))).thenReturn((Object)((IndexedRaftLogEntry)Mockito.mock(IndexedRaftLogEntry.class)));
        AppendResponse response = (AppendResponse)this.role.handleAppend(ProtocolVersionHandler.transform((VersionedAppendRequest)request)).join();
        ((RaftLog)Mockito.verify((Object)this.log, (VerificationMode)Mockito.times((int)1))).flush();
        Assertions.assertThat((long)response.lastLogIndex()).isEqualTo(2L);
    }

    @Test
    public void shouldFlushAfterPartiallyAppendedRequest() throws CheckedJournalException {
        List<ReplicatableJournalRecord> entries = List.of(new ReplicatableJournalRecord(1L, 1L, 1L, new byte[1]), new ReplicatableJournalRecord(1L, 2L, 1L, new byte[1]));
        VersionedAppendRequest request = VersionedAppendRequest.builder().withTerm(1L).withLeader(MemberId.anonymous()).withPrevLogTerm(0L).withPrevLogIndex(0L).withEntries(entries).withCommitIndex(2L).build();
        Mockito.when((Object)this.log.append((ReplicatableJournalRecord)ArgumentMatchers.any(ReplicatableJournalRecord.class))).thenReturn((Object)((IndexedRaftLogEntry)Mockito.mock(IndexedRaftLogEntry.class))).thenThrow(new Throwable[]{new JournalException.InvalidChecksum("expected")});
        AppendResponse response = (AppendResponse)this.role.handleAppend(ProtocolVersionHandler.transform((VersionedAppendRequest)request)).join();
        ((RaftLog)Mockito.verify((Object)this.log, (VerificationMode)Mockito.times((int)1))).flush();
        Assertions.assertThat((long)response.lastLogIndex()).isOne();
    }

    @Test
    public void shouldNotFlushIfNoEntryIsAppended() throws CheckedJournalException {
        List<ReplicatableJournalRecord> entries = List.of(new ReplicatableJournalRecord(1L, 1L, 1L, new byte[1]));
        VersionedAppendRequest request = VersionedAppendRequest.builder().withTerm(1L).withLeader(MemberId.anonymous()).withPrevLogTerm(0L).withPrevLogIndex(0L).withEntries(entries).withCommitIndex(2L).build();
        Mockito.when((Object)this.log.append((ReplicatableJournalRecord)ArgumentMatchers.any(ReplicatableJournalRecord.class))).thenThrow(new Throwable[]{new JournalException.InvalidChecksum("expected")});
        AppendResponse response = (AppendResponse)this.role.handleAppend(ProtocolVersionHandler.transform((VersionedAppendRequest)request)).join();
        ((RaftLog)Mockito.verify((Object)this.log, (VerificationMode)Mockito.never())).flush();
        Assertions.assertThat((long)response.lastLogIndex()).isZero();
    }

    @Test
    public void shouldFlushEventWithFailure() throws CheckedJournalException {
        List<ReplicatableJournalRecord> entries = List.of(new ReplicatableJournalRecord(1L, 1L, 1L, new byte[1]), new ReplicatableJournalRecord(1L, 2L, 1L, new byte[1]), new ReplicatableJournalRecord(1L, 3L, 1L, new byte[1]));
        VersionedAppendRequest request = VersionedAppendRequest.builder().withTerm(1L).withLeader(MemberId.anonymous()).withPrevLogTerm(0L).withPrevLogIndex(0L).withEntries(entries).withCommitIndex(3L).build();
        Mockito.when((Object)this.log.append((ReplicatableJournalRecord)ArgumentMatchers.any(ReplicatableJournalRecord.class))).thenReturn((Object)((IndexedRaftLogEntry)Mockito.mock(IndexedRaftLogEntry.class))).thenReturn((Object)((IndexedRaftLogEntry)Mockito.mock(IndexedRaftLogEntry.class))).thenThrow(new Throwable[]{new JournalException.InvalidChecksum("expected")});
        Mockito.when((Object)this.ctx.getLog()).thenReturn((Object)this.log);
        this.role.handleAppend(ProtocolVersionHandler.transform((VersionedAppendRequest)request)).join();
        ((RaftLog)Mockito.verify((Object)this.log, (VerificationMode)Mockito.times((int)1))).flush();
    }

    @Test
    public void shouldAppendOldVersion() throws CheckedJournalException {
        List<PersistedRaftRecord> entries = List.of(new PersistedRaftRecord(1L, 1L, 1L, 1L, new byte[1]));
        AppendRequest request = new AppendRequest(2L, "a", 0L, 0L, entries, 1L);
        Mockito.when((Object)this.log.append((PersistedRaftRecord)ArgumentMatchers.any(PersistedRaftRecord.class))).thenReturn((Object)((IndexedRaftLogEntry)Mockito.mock(IndexedRaftLogEntry.class)));
        AppendResponse response = (AppendResponse)this.role.handleAppend(ProtocolVersionHandler.transform((AppendRequest)request)).join();
        Assertions.assertThat((boolean)response.succeeded()).isTrue();
    }

    @Test
    public void shouldCompleteFutureWithErrorIfAppendFails() throws CheckedJournalException {
        List<PersistedRaftRecord> entries = List.of(new PersistedRaftRecord(1L, 1L, 1L, 1L, new byte[1]));
        AppendRequest request = new AppendRequest(2L, "a", 0L, 0L, entries, 1L);
        Mockito.when((Object)this.log.append((PersistedRaftRecord)ArgumentMatchers.any(PersistedRaftRecord.class))).thenThrow(new Throwable[]{new IllegalStateException("error")});
        AppendResponse result = (AppendResponse)this.role.handleAppend(ProtocolVersionHandler.transform((AppendRequest)request)).toCompletableFuture().join();
        Assertions.assertThat((boolean)result.succeeded()).isFalse();
    }
}

