/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.protocol;

import com.google.common.collect.Maps;
import io.atomix.cluster.MemberId;
import io.atomix.raft.protocol.TestRaftServerProtocol;
import java.util.Map;

public class TestRaftProtocolFactory {
    private final Map<MemberId, TestRaftServerProtocol> servers = Maps.newConcurrentMap();

    public TestRaftServerProtocol newServerProtocol(MemberId memberId) {
        TestRaftServerProtocol protocol = new TestRaftServerProtocol(memberId, this.servers);
        this.servers.put(memberId, protocol);
        return protocol;
    }

    public void partition(MemberId target) {
        this.servers.keySet().forEach(other -> this.partition(target, (MemberId)other));
    }

    public void blockMessagesTo(MemberId target) {
        this.servers.keySet().forEach(other -> this.servers.get(other).disconnect(target));
    }

    private void partition(MemberId first, MemberId second) {
        this.servers.get(first).disconnect(second);
        this.servers.get(second).disconnect(first);
    }

    public void heal(MemberId target) {
        this.servers.keySet().forEach(other -> this.heal(target, (MemberId)other));
    }

    private void heal(MemberId first, MemberId second) {
        this.servers.get(first).reconnect(second);
        this.servers.get(second).reconnect(first);
    }
}

