/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft;

import io.atomix.raft.RaftRule;
import io.atomix.raft.storage.log.entry.ApplicationEntry;
import io.atomix.raft.storage.log.entry.InitialEntry;
import io.atomix.raft.storage.log.entry.SerializedApplicationEntry;
import io.atomix.raft.zeebe.EntryValidator;
import io.camunda.zeebe.test.util.TestUtil;
import java.util.Collection;
import java.util.function.BiFunction;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;

public class SingleRaftEntryValidationTest {
    private final TestEntryValidator entryValidator = new TestEntryValidator();
    @Rule
    public RaftRule raftRule = RaftRule.withBootstrappedNodes(1).setEntryValidator(this.entryValidator);

    @Test
    public void shouldFailAppendOnInvalidEntry() {
        this.entryValidator.validation = (last, current) -> EntryValidator.ValidationResult.failure((String)"invalid");
        Assertions.assertThatThrownBy(() -> this.raftRule.appendEntry()).hasMessageContaining("invalid");
    }

    @Test
    public void shouldNotAppendInvalidEntryToLog() throws Exception {
        this.entryValidator.validation = (last, current) -> EntryValidator.ValidationResult.failure((String)"invalid");
        Assertions.assertThatThrownBy(() -> this.raftRule.appendEntry()).hasMessageContaining("invalid");
        this.entryValidator.validation = (last, current) -> EntryValidator.ValidationResult.ok();
        TestUtil.waitUntil(() -> this.getEntryTypeCount(InitialEntry.class) == 2);
        this.raftRule.appendEntry();
        Assertions.assertThat((int)this.getEntryTypeCount(SerializedApplicationEntry.class)).isOne();
    }

    private int getEntryTypeCount(Class type) {
        return (int)this.raftRule.getMemberLogs().values().stream().flatMap(Collection::stream).filter(e -> e.entry().getClass().isAssignableFrom(type)).count();
    }

    private static final class TestEntryValidator
    implements EntryValidator {
        BiFunction<ApplicationEntry, ApplicationEntry, EntryValidator.ValidationResult> validation;

        private TestEntryValidator() {
        }

        public EntryValidator.ValidationResult validateEntry(ApplicationEntry lastEntry, ApplicationEntry entry) {
            return this.validation.apply(lastEntry, entry);
        }
    }
}

