/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft;

import io.atomix.cluster.MemberId;
import io.atomix.raft.ControllableRaftContexts;
import io.atomix.raft.RaftOperation;
import io.atomix.raft.cluster.RaftMember;
import io.atomix.raft.impl.RaftContext;
import io.atomix.raft.impl.ReconfigurationHelper;
import io.camunda.zeebe.util.FileUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCasesMode;
import net.jqwik.api.ForAll;
import net.jqwik.api.Property;
import net.jqwik.api.Provide;
import net.jqwik.api.ShrinkingMode;
import net.jqwik.api.lifecycle.AfterTry;
import net.jqwik.api.lifecycle.BeforeProperty;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RandomizedForceConfigureTest {
    private static final int OPERATION_SIZE = 2000;
    private static final int NODE_COUNT = 4;
    private static final Logger LOG = LoggerFactory.getLogger(RandomizedForceConfigureTest.class);
    private ControllableRaftContexts raftContexts;
    private List<RaftOperation> defaultOperations;
    private final ForceConfigureOperation forceConfigureOperation = new ForceConfigureOperation();
    private List<MemberId> raftMembers;
    private Path raftDataDirectory;

    @BeforeProperty
    public void initOperations() {
        List servers = IntStream.range(0, 4).mapToObj(String::valueOf).map(MemberId::from).collect(Collectors.toList());
        this.defaultOperations = RaftOperation.getRaftOperationsWithSnapshot();
        this.defaultOperations.add(RaftOperation.of("Force configure (0,2)", this.forceConfigureOperation::run));
        this.raftMembers = servers;
    }

    @AfterTry
    public void shutDownRaftNodes() throws IOException {
        this.raftContexts.shutdown();
        FileUtil.deleteFolder((Path)this.raftDataDirectory);
        this.raftDataDirectory = null;
        this.forceConfigureOperation.reset();
        LOG.info("=== Try completed ===");
    }

    @Property(tries=10, shrinking=ShrinkingMode.OFF, edgeCases=EdgeCasesMode.NONE)
    public void correctnessTest(@ForAll(value="raftOperations") List<RaftOperation> raftOperations, @ForAll(value="raftMembers") List<MemberId> raftMembers, @ForAll(value="seeds") long seed) throws Exception {
        this.setUpRaftNodes(new Random(seed));
        while (!this.raftContexts.allMembersAreReady()) {
            this.raftContexts.runUntilDone();
            this.raftContexts.processAllMessage();
            this.raftContexts.tickHeartbeatTimeout();
        }
        Iterator<MemberId> memberIter = raftMembers.iterator();
        for (RaftOperation operation : raftOperations) {
            MemberId member = memberIter.next();
            LOG.info("{} on {}", (Object)operation, (Object)member);
            operation.run(this.raftContexts, member);
        }
        this.forceConfigureOperation.run(this.raftContexts, MemberId.from((String)"0"));
        for (int i = 0; i < 10; ++i) {
            this.raftContexts.runUntilDone();
            this.raftContexts.processAllMessage();
            this.raftContexts.tickHeartbeatTimeout();
        }
        Map<MemberId, RaftContext> newMembers = Map.of(MemberId.from((String)"0"), this.raftContexts.getRaftContext(0), MemberId.from((String)"2"), this.raftContexts.getRaftContext(2));
        this.runUntilMembersAreInSync(newMembers);
        this.assertThatConfigurationContainsOnly0and2(0);
        this.assertThatConfigurationContainsOnly0and2(2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.raftContexts.hasLeaderAtTheLatestTerm()).describedAs("Leader election should be completed if there are no messages lost.", new Object[0])).isTrue();
        this.raftContexts.assertAllEntriesCommittedAndReplicatedToAll(newMembers);
        this.raftContexts.assertAllLogsEqual();
        this.raftContexts.assertNoGapsInLog();
        this.raftContexts.assertNoJournalAppendErrors();
        this.raftContexts.assertNoDataLoss();
    }

    private void runUntilMembersAreInSync(Map<MemberId, RaftContext> newMembers) {
        int maxStepsToReplicateEntries = 2000;
        while (!(this.raftContexts.hasLeaderAtTheLatestTerm() && this.raftContexts.hasReplicatedAllEntries(newMembers) && this.raftContexts.hasCommittedAllEntries(newMembers) || maxStepsToReplicateEntries-- <= 0)) {
            this.raftContexts.runUntilDone();
            this.raftContexts.processAllMessage();
            this.raftContexts.tickHeartbeatTimeout();
        }
    }

    private void assertThatConfigurationContainsOnly0and2(int memberId) {
        List<String> members = this.raftContexts.getRaftContext(memberId).getCluster().getConfiguration().allMembers().stream().map(r -> (String)((Object)r.memberId().id())).toList();
        ((ListAssert)Assertions.assertThat(members).describedAs("Configuration must have only members 0 and 2", new Object[0])).containsExactlyInAnyOrder((Object[])new String[]{"0", "2"});
    }

    @Provide
    Arbitrary<List<RaftOperation>> raftOperations() {
        Arbitrary operation = Arbitraries.of(this.defaultOperations);
        return operation.list().ofSize(2000);
    }

    @Provide
    Arbitrary<List<MemberId>> raftMembers() {
        Arbitrary members = Arbitraries.of(this.raftMembers);
        return members.list().ofSize(2000);
    }

    @Provide
    Arbitrary<Long> seeds() {
        return Arbitraries.longs();
    }

    private void setUpRaftNodes(Random random) throws Exception {
        this.raftDataDirectory = Files.createTempDirectory(null, new FileAttribute[0]);
        this.raftContexts = new ControllableRaftContexts(4);
        this.raftContexts.setup(this.raftDataDirectory, random);
    }

    private static final class ForceConfigureOperation {
        private CompletableFuture<Void> forceConfigureCompleted = new CompletableFuture();

        private ForceConfigureOperation() {
        }

        public void reset() {
            this.forceConfigureCompleted = new CompletableFuture();
        }

        public void run(ControllableRaftContexts raftContexts, MemberId memberId) {
            if (this.forceConfigureCompleted.isDone()) {
                return;
            }
            new ReconfigurationHelper(raftContexts.getRaftContext(0)).forceConfigure(Map.of(MemberId.from((String)"0"), RaftMember.Type.ACTIVE, MemberId.from((String)"2"), RaftMember.Type.ACTIVE)).thenApply(ignore -> this.forceConfigureCompleted.complete(null));
        }
    }
}

