/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft;

import io.atomix.raft.RaftRule;
import io.atomix.raft.RaftServer;
import io.atomix.raft.impl.RaftContext;
import org.awaitility.Awaitility;
import org.junit.Rule;
import org.junit.Test;

public class RaftSingleNodeTest {
    @Rule
    public final RaftRule rule = RaftRule.withBootstrappedNodes(1);

    @Test
    public void singleNodeClusterShouldBecomeReadyOnRestart() throws Exception {
        RaftServer server = this.rule.getServers().iterator().next();
        String name = server.name();
        Awaitility.await((String)"Node should become ready").until(() -> server.getContext().getState() == RaftContext.State.READY);
        this.rule.shutdownLeader();
        this.rule.joinCluster(name);
        Awaitility.await((String)"Node should become ready").until(() -> server.getContext().getState() == RaftContext.State.READY);
    }
}

