/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft;

import io.atomix.cluster.MemberId;
import io.atomix.raft.RaftRule;
import io.atomix.raft.RaftServer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;

public class RaftServerDisconnectTest {
    @Rule
    @Parameterized.Parameter
    public RaftRule raftRule = RaftRule.withBootstrappedNodes(3);

    @Test
    public void shouldLeaderStepDownOnDisconnect() throws Throwable {
        RaftServer leader = this.raftRule.getLeader().orElseThrow();
        CountDownLatch stepDownListener = new CountDownLatch(1);
        leader.addRoleChangeListener((role, term) -> {
            if (role == RaftServer.Role.FOLLOWER) {
                stepDownListener.countDown();
            }
        });
        this.raftRule.partition(leader);
        Assertions.assertThat((boolean)stepDownListener.await(30L, TimeUnit.SECONDS)).isTrue();
        Assertions.assertThat((boolean)leader.isLeader()).isFalse();
    }

    @Test
    public void shouldReconnect() throws Throwable {
        RaftServer leader = this.raftRule.getLeader().orElseThrow();
        AtomicLong commitIndex = new AtomicLong();
        leader.getContext().addCommitListener(commitIndex::set);
        this.raftRule.appendEntry();
        this.raftRule.partition(leader);
        Awaitility.await().until(() -> !leader.isLeader());
        this.raftRule.awaitNewLeader();
        RaftServer newLeader = this.raftRule.getLeader().orElseThrow();
        Assertions.assertThat((Object)leader).isNotEqualTo((Object)newLeader);
        long secondCommit = this.raftRule.appendEntry();
        this.raftRule.reconnect(leader);
        Awaitility.await().until(() -> commitIndex.get() >= secondCommit);
    }

    @Test
    public void shouldFailOverOnLeaderDisconnect() throws Throwable {
        RaftServer leader = this.raftRule.getLeader().orElseThrow();
        MemberId leaderId = leader.getContext().getCluster().getLocalMember().memberId();
        CountDownLatch newLeaderElected = new CountDownLatch(1);
        AtomicReference newLeaderId = new AtomicReference();
        this.raftRule.getServers().forEach(s -> s.addRoleChangeListener((role, term) -> {
            if (role == RaftServer.Role.LEADER && !s.equals((Object)leader)) {
                newLeaderId.set(s.getContext().getCluster().getLocalMember().memberId());
                newLeaderElected.countDown();
            }
        }));
        this.raftRule.partition(leader);
        Assertions.assertThat((boolean)newLeaderElected.await(30L, TimeUnit.SECONDS)).isTrue();
        Assertions.assertThat((Comparable)leaderId).isNotEqualTo(newLeaderId.get());
    }
}

