/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft;

import io.atomix.raft.RaftRule;
import io.atomix.raft.RaftServer;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;

public class RaftResetTermAfterRestoreTest {
    @Rule
    public RaftRule raftRule = RaftRule.withBootstrappedNodes(1);

    @Test
    public void shouldResetTermFromLastLogEntryIfMetastoreIsEmpty() throws Exception {
        this.raftRule.appendEntries(1);
        RaftServer raftServer = this.raftRule.getServers().stream().findFirst().get();
        String serverId = (String)((Object)raftServer.cluster().getLocalMember().memberId().id());
        long termBeforeShutdown = raftServer.getTerm();
        this.raftRule.shutdownServer(raftServer);
        Assertions.assertThat((long)termBeforeShutdown).isEqualTo(1L);
        File partitionDirectory = raftServer.getContext().getStorage().directory();
        try (Stream<Path> fileStream = Files.list(partitionDirectory.toPath());){
            Path metaFilePath = fileStream.filter(p -> p.getFileName().toString().endsWith("meta")).findFirst().orElseThrow(() -> new RuntimeException("No meta file found"));
            Files.delete(metaFilePath);
        }
        this.raftRule.joinCluster(serverId);
        ((AbstractLongAssert)Assertions.assertThat((long)this.raftRule.getLeader().orElseThrow().getTerm()).describedAs("Should reset term by reading the last entry in the log", new Object[0])).isEqualTo(2L);
    }
}

