/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft;

import io.atomix.raft.RaftRule;
import io.atomix.raft.RaftServer;
import io.atomix.raft.impl.RaftContext;
import io.atomix.raft.storage.log.IndexedRaftLogEntry;
import io.camunda.zeebe.snapshots.PersistedSnapshot;
import io.camunda.zeebe.snapshots.PersistedSnapshotStore;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.awaitility.Awaitility;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class RaftFailOverIT {
    private static final Logger LOG = LoggerFactory.getLogger(RaftFailOverIT.class);
    @Rule
    @Parameterized.Parameter
    public RaftRule raftRule;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Object[][] raftConfigurations() {
        return new Object[][]{{RaftRule.withBootstrappedNodes(3)}, {RaftRule.withBootstrappedNodes(4)}, {RaftRule.withBootstrappedNodes(5)}};
    }

    @Test
    public void shouldCommitEntriesAfterFollowerShutdown() throws Throwable {
        int entryCount = 20;
        this.raftRule.appendEntries(20);
        this.raftRule.shutdownFollower();
        long lastIndex = this.raftRule.appendEntries(20);
        this.raftRule.awaitSameLogSizeOnAllNodes(lastIndex);
        Map<String, List<IndexedRaftLogEntry>> memberLog = this.raftRule.getMemberLogs();
        Long maxIndex = memberLog.values().stream().flatMap(Collection::stream).map(IndexedRaftLogEntry::index).max(Long::compareTo).orElseThrow();
        Assertions.assertThat((Long)maxIndex).isEqualTo(lastIndex);
        this.assertMemberLogs(memberLog);
    }

    @Test
    public void onFollowerRestartItBecomesReady() throws Exception {
        Awaitility.await((String)"Leader is up").until(() -> this.raftRule.getLeader().isPresent());
        Assertions.assertThat((long)this.raftRule.getServers().stream().map(s -> s.getContext().getCommitIndex()).distinct().count()).isEqualTo(1L);
        String follower = this.raftRule.shutdownFollower();
        this.raftRule.joinCluster(follower);
        RaftServer server = this.raftRule.getServer(follower);
        Awaitility.await((String)"Follower should be ready").until(() -> server.getContext().getState() == RaftContext.State.READY);
    }

    @Test
    public void onFollowerRestartItBecomesReadyOnlyAfterCatchingUp() throws Exception {
        Awaitility.await((String)"Leader is up").until(() -> this.raftRule.getLeader().isPresent());
        Assertions.assertThat((long)this.raftRule.getServers().stream().map(s -> s.getContext().getCommitIndex()).distinct().count()).isEqualTo(1L);
        String follower = this.raftRule.shutdownFollower();
        this.raftRule.appendEntries(32);
        CompletableFuture<Void> bootstrapFuture = this.raftRule.bootstrapNodeAsync(follower);
        RaftServer server = this.raftRule.getServer(follower);
        TreeMap states = new TreeMap();
        server.getContext().addStateChangeListener(state -> {
            long commitIdx = server.getContext().getCommitIndex();
            states.put(commitIdx, state);
        });
        bootstrapFuture.join();
        Assertions.assertThat(states).isEqualTo(Map.ofEntries(Map.entry(1L, RaftContext.State.ACTIVE), Map.entry(33L, RaftContext.State.READY)));
    }

    @Test
    public void shouldCommitEntriesAfterLeaderShutdown() throws Throwable {
        int entryCount = 20;
        this.raftRule.appendEntries(20);
        this.raftRule.shutdownLeader();
        this.raftRule.awaitNewLeader();
        long lastIndex = this.raftRule.appendEntries(20);
        this.raftRule.awaitSameLogSizeOnAllNodes(lastIndex);
        Map<String, List<IndexedRaftLogEntry>> memberLog = this.raftRule.getMemberLogs();
        Long maxIndex = memberLog.values().stream().flatMap(Collection::stream).map(IndexedRaftLogEntry::index).max(Long::compareTo).orElseThrow();
        Assertions.assertThat((Long)maxIndex).isEqualTo(lastIndex);
        this.assertMemberLogs(memberLog);
    }

    @Test
    public void shouldRecoverLeaderRestart() throws Throwable {
        int entryCount = 20;
        this.raftRule.appendEntries(20);
        this.raftRule.restartLeader();
        this.raftRule.awaitNewLeader();
        long lastIndex = this.raftRule.appendEntries(20);
        this.raftRule.awaitSameLogSizeOnAllNodes(lastIndex);
        Map<String, List<IndexedRaftLogEntry>> memberLog = this.raftRule.getMemberLogs();
        Long maxIndex = memberLog.values().stream().flatMap(Collection::stream).map(IndexedRaftLogEntry::index).max(Long::compareTo).orElseThrow();
        Assertions.assertThat((Long)maxIndex).isEqualTo(lastIndex);
        this.assertMemberLogs(memberLog);
    }

    @Test
    public void shouldTakeSnapshot() throws Exception {
        this.raftRule.appendEntries(228);
        this.raftRule.takeSnapshot(200L);
        Assertions.assertThat((boolean)this.raftRule.allNodesHaveSnapshotWithIndex(200L)).isTrue();
    }

    @Test
    public void shouldCompactLogOnSnapshot() throws Exception {
        long lastIndex = this.raftRule.appendEntries(228);
        this.raftRule.awaitSameLogSizeOnAllNodes(lastIndex);
        Map<String, List<IndexedRaftLogEntry>> memberLogs = this.raftRule.getMemberLogs();
        this.raftRule.takeCompactingSnapshot(200L);
        Map<String, List<IndexedRaftLogEntry>> compactedLogs = this.raftRule.getMemberLogs();
        Assertions.assertThat(compactedLogs).isNotEmpty();
        for (String raftMember : compactedLogs.keySet()) {
            List<IndexedRaftLogEntry> compactedLog = compactedLogs.get(raftMember);
            List<IndexedRaftLogEntry> previousLog = memberLogs.get(raftMember);
            ((ListAssert)Assertions.assertThat(compactedLog).hasSizeLessThan(previousLog.size())).isSubsetOf(previousLog);
        }
    }

    @Test
    public void shouldReplicateSnapshotOnJoin() throws Exception {
        String follower = this.raftRule.shutdownFollower();
        this.raftRule.appendEntries(128);
        this.raftRule.takeCompactingSnapshot(200L);
        PersistedSnapshot leaderSnapshot = this.raftRule.getSnapshotFromLeader();
        this.raftRule.joinCluster(follower);
        Assertions.assertThat((boolean)this.raftRule.allNodesHaveSnapshotWithIndex(200L)).isTrue();
        PersistedSnapshot snapshot = this.raftRule.getSnapshotOnNode(follower);
        Assertions.assertThat((long)snapshot.getIndex()).isEqualTo(leaderSnapshot.getIndex()).isEqualTo(200L);
        Assertions.assertThat((long)snapshot.getTerm()).isEqualTo(snapshot.getTerm());
    }

    @Test
    public void shouldReplicateSnapshotWithManyFilesOnJoin() throws Exception {
        String follower = this.raftRule.shutdownFollower();
        this.raftRule.appendEntries(130);
        long snapshotIndex = 120L;
        this.raftRule.takeCompactingSnapshot(120L, 10);
        PersistedSnapshot leaderSnapshot = this.raftRule.getSnapshotFromLeader();
        this.raftRule.joinCluster(follower);
        Assertions.assertThat((boolean)this.raftRule.allNodesHaveSnapshotWithIndex(120L)).isTrue();
        PersistedSnapshot snapshot = this.raftRule.getSnapshotOnNode(follower);
        Assertions.assertThat((long)snapshot.getIndex()).isEqualTo(leaderSnapshot.getIndex()).isEqualTo(120L);
        Assertions.assertThat((long)snapshot.getTerm()).isEqualTo(snapshot.getTerm());
    }

    @Test
    public void shouldReplicateEntriesAfterSnapshotOnJoin() throws Exception {
        String follower = this.raftRule.shutdownFollower();
        this.raftRule.appendEntries(228);
        this.raftRule.takeCompactingSnapshot(200L);
        LOG.debug("Follower %s joining cluster".formatted(follower));
        this.raftRule.joinCluster(follower);
        Assertions.assertThat((boolean)this.raftRule.allNodesHaveSnapshotWithIndex(200L)).isTrue();
        Map<String, List<IndexedRaftLogEntry>> memberLogs = this.raftRule.getMemberLogs();
        List<IndexedRaftLogEntry> entries = memberLogs.get(follower);
        Assertions.assertThat((long)entries.get(0).index()).isEqualTo(201L);
        for (String member : memberLogs.keySet()) {
            if (follower.equals(member)) continue;
            List<IndexedRaftLogEntry> memberEntries = memberLogs.get(member);
            Assertions.assertThat(memberEntries).endsWith((Object[])entries.toArray(new IndexedRaftLogEntry[0]));
        }
    }

    @Test
    public void shouldReplicateSnapshotAfterDataLoss() throws Exception {
        this.raftRule.appendEntries(228);
        this.raftRule.takeCompactingSnapshot(200L);
        String follower = this.raftRule.shutdownFollower();
        PersistedSnapshot leaderSnapshot = this.raftRule.getSnapshotFromLeader();
        this.raftRule.triggerDataLossOnNode(follower);
        this.raftRule.bootstrapNode(follower);
        Assertions.assertThat((boolean)this.raftRule.allNodesHaveSnapshotWithIndex(200L)).isTrue();
        PersistedSnapshot snapshot = this.raftRule.getSnapshotOnNode(follower);
        Assertions.assertThat((long)snapshot.getIndex()).isEqualTo(leaderSnapshot.getIndex()).isEqualTo(200L);
        Assertions.assertThat((long)snapshot.getTerm()).isEqualTo(leaderSnapshot.getTerm());
        Assertions.assertThat((String)snapshot.getId()).isEqualTo(leaderSnapshot.getId());
    }

    @Test
    public void shouldReplicateEntriesAfterDataLoss() throws Exception {
        this.raftRule.appendEntries(128);
        String follower = this.raftRule.shutdownFollower();
        this.raftRule.triggerDataLossOnNode(follower);
        this.raftRule.bootstrapNode(follower);
        Map<String, List<IndexedRaftLogEntry>> memberLogs = this.raftRule.getMemberLogs();
        List<IndexedRaftLogEntry> entries = memberLogs.get(follower);
        for (String member : memberLogs.keySet()) {
            if (follower.equals(member)) continue;
            List<IndexedRaftLogEntry> memberEntries = memberLogs.get(member);
            ((ListAssert)Assertions.assertThat(memberEntries).hasSameSizeAs(entries)).isEqualTo(entries);
        }
    }

    @Test
    public void shouldReplicateSnapshotMultipleTimesAfterMultipleDataLoss() throws Exception {
        this.raftRule.appendEntries(228);
        this.raftRule.takeCompactingSnapshot(200L);
        String follower = this.raftRule.shutdownFollower();
        PersistedSnapshot leaderSnapshot = this.raftRule.getSnapshotFromLeader();
        this.raftRule.triggerDataLossOnNode(follower);
        this.raftRule.bootstrapNode(follower);
        PersistedSnapshot firstSnapshot = this.raftRule.getSnapshotOnNode(follower);
        this.raftRule.shutdownServer(follower);
        this.raftRule.triggerDataLossOnNode(follower);
        this.raftRule.bootstrapNode(follower);
        Assertions.assertThat((boolean)this.raftRule.allNodesHaveSnapshotWithIndex(200L)).isTrue();
        PersistedSnapshot newSnapshot = this.raftRule.getSnapshotOnNode(follower);
        Assertions.assertThat((long)newSnapshot.getIndex()).isEqualTo(leaderSnapshot.getIndex()).isEqualTo(200L);
        Assertions.assertThat((long)newSnapshot.getTerm()).isEqualTo(leaderSnapshot.getTerm());
        Assertions.assertThat((String)newSnapshot.getId()).isEqualTo(leaderSnapshot.getId());
        Assertions.assertThat((Object)newSnapshot).isEqualTo((Object)firstSnapshot);
    }

    @Test
    public void shouldReplicateEntriesAfterSnapshotAfterDataLoss() throws Exception {
        this.raftRule.appendEntries(228);
        this.raftRule.takeCompactingSnapshot(200L);
        String follower = this.raftRule.shutdownFollower();
        this.raftRule.triggerDataLossOnNode(follower);
        this.raftRule.bootstrapNode(follower);
        Assertions.assertThat((boolean)this.raftRule.allNodesHaveSnapshotWithIndex(200L)).isTrue();
        Map<String, List<IndexedRaftLogEntry>> memberLogs = this.raftRule.getMemberLogs();
        List<IndexedRaftLogEntry> entries = memberLogs.get(follower);
        Assertions.assertThat((long)entries.get(0).index()).isEqualTo(201L);
        for (String member : memberLogs.keySet()) {
            if (follower.equals(member)) continue;
            List<IndexedRaftLogEntry> memberEntries = memberLogs.get(member);
            Assertions.assertThat(memberEntries).endsWith((Object[])entries.toArray(new IndexedRaftLogEntry[0]));
        }
    }

    @Test
    public void shouldTakeMultipleSnapshotsAndReplicateSnapshotAfterRestart() throws Exception {
        this.raftRule.appendEntries(228);
        this.raftRule.takeCompactingSnapshot(200L);
        String follower = this.raftRule.shutdownFollower();
        this.raftRule.appendEntries(128);
        this.raftRule.takeCompactingSnapshot(300L);
        this.raftRule.appendEntries(128);
        this.raftRule.takeCompactingSnapshot(400L);
        PersistedSnapshot leaderSnapshot = this.raftRule.getSnapshotFromLeader();
        this.raftRule.joinCluster(follower);
        Assertions.assertThat((boolean)this.raftRule.allNodesHaveSnapshotWithIndex(400L)).isTrue();
        PersistedSnapshot snapshot = this.raftRule.getSnapshotOnNode(follower);
        Assertions.assertThat((long)snapshot.getIndex()).isEqualTo(leaderSnapshot.getIndex()).isEqualTo(400L);
        Assertions.assertThat((long)snapshot.getTerm()).isEqualTo(snapshot.getTerm());
    }

    @Test
    public void shouldReplicateSnapshotToOldLeaderAfterRestart() throws Exception {
        this.raftRule.appendEntries(228);
        this.raftRule.takeCompactingSnapshot(200L);
        String leader = this.raftRule.shutdownLeader();
        this.raftRule.awaitNewLeader();
        this.raftRule.appendEntries(228);
        this.raftRule.takeCompactingSnapshot(400L);
        PersistedSnapshot leaderSnapshot = this.raftRule.getSnapshotFromLeader();
        this.raftRule.joinCluster(leader);
        Assertions.assertThat((boolean)this.raftRule.allNodesHaveSnapshotWithIndex(400L)).isTrue();
        PersistedSnapshot snapshot = this.raftRule.getSnapshotOnNode(leader);
        Assertions.assertThat((long)snapshot.getIndex()).isEqualTo(leaderSnapshot.getIndex()).isEqualTo(400L);
        Assertions.assertThat((long)snapshot.getTerm()).isEqualTo(snapshot.getTerm());
    }

    @Test
    public void shouldTruncateLogOnNewerSnapshot() throws Throwable {
        this.raftRule.appendEntries(50);
        String followerB = this.raftRule.shutdownFollower();
        this.raftRule.appendEntries(250);
        this.raftRule.takeCompactingSnapshot(200L);
        this.raftRule.joinCluster(followerB);
        this.raftRule.appendEntries(100);
        Assertions.assertThat((boolean)this.raftRule.allNodesHaveSnapshotWithIndex(200L)).isTrue();
        Map<String, List<IndexedRaftLogEntry>> memberLogs = this.raftRule.getMemberLogs();
        List<IndexedRaftLogEntry> entries = memberLogs.get(followerB);
        Assertions.assertThat((long)entries.get(0).index()).isEqualTo(201L);
    }

    @Test
    public void shouldNotReplicateSnapshotWhenIndexIsZero() throws Exception {
        String follower = this.raftRule.shutdownFollower();
        this.raftRule.appendEntries(100);
        this.raftRule.takeSnapshot(0L);
        PersistedSnapshot leaderSnapshot = this.raftRule.getSnapshotFromLeader();
        Assertions.assertThat((long)leaderSnapshot.getIndex()).isZero();
        this.raftRule.joinCluster(follower);
        Map<String, List<IndexedRaftLogEntry>> memberLogs = this.raftRule.getMemberLogs();
        this.assertMemberLogs(memberLogs);
        PersistedSnapshotStore followerSnapshotStore = this.raftRule.getPersistedSnapshotStore(follower);
        Assertions.assertThat((Optional)followerSnapshotStore.getLatestSnapshot()).isNotPresent();
    }

    private void assertMemberLogs(Map<String, List<IndexedRaftLogEntry>> memberLog) {
        Set<String> members = memberLog.keySet();
        Iterator<String> iterator = members.iterator();
        if (iterator.hasNext()) {
            String first = iterator.next();
            List<IndexedRaftLogEntry> firstMemberEntries = memberLog.get(first);
            while (iterator.hasNext()) {
                List<IndexedRaftLogEntry> otherEntries = memberLog.get(iterator.next());
                ((ListAssert)Assertions.assertThat(firstMemberEntries).withFailMessage(memberLog.toString(), new Object[0])).containsExactly((Object[])otherEntries.toArray(new IndexedRaftLogEntry[0]));
            }
        }
    }
}

