/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft;

import io.atomix.cluster.MemberId;
import io.atomix.raft.RaftRule;
import io.atomix.raft.RaftServer;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.DisplayName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftCorruptedDataTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(RaftCorruptedDataTest.class);
    @Rule
    public RaftRule raftRule = RaftRule.withBootstrappedNodes(3);

    @Test
    @DisplayName(value="When nodes with corrupted data forms a quorum, the remaining one should not delete its files")
    public void upToDateFollowerShouldNotLoseDataWhenQuorumExperienceCorruption() throws Exception {
        RaftServer[] servers = (RaftServer[])this.raftRule.getServers().toArray(RaftServer[]::new);
        MemberId node0 = MemberId.from((String)servers[0].name());
        MemberId node1 = MemberId.from((String)servers[1].name());
        MemberId node2 = MemberId.from((String)servers[2].name());
        this.raftRule.appendEntries(100);
        this.raftRule.appendEntries(1);
        Awaitility.await((String)"commitIndex is > 0 on all nodes").until(() -> Arrays.stream(servers).allMatch(s -> s.getContext().getCommitIndex() >= 100L));
        long commitIndex = servers[2].getContext().getCommitIndex();
        for (RaftServer server : servers) {
            this.raftRule.shutdownServer(server);
        }
        this.raftRule.triggerDataLossOnNode((String)((Object)node0.id()));
        this.raftRule.triggerDataLossOnNode((String)((Object)node1.id()));
        RaftServer server0 = this.raftRule.createServer(node0);
        RaftServer server1 = this.raftRule.createServer(node1);
        CompletableFuture.allOf(server0.bootstrap(new MemberId[]{node0, node1, node2}), server1.bootstrap(new MemberId[]{node0, node1, node2})).join();
        Awaitility.await((String)"corrupted nodes form a quorum").until(() -> server0.isLeader() || server1.isLeader());
        RaftServer server2 = this.raftRule.createServer(node2);
        server2.bootstrap(new MemberId[]{node0, node1, node2});
        Awaitility.await((String)"node becomes INACTIVE").atMost(Duration.ofSeconds(30L)).until(() -> server2.getRole().equals((Object)RaftServer.Role.INACTIVE));
    }

    @Test
    @DisplayName(value="When nodes with corrupted data forms a quorum, the remaining one should not delete its files even if quorum term is > 1")
    public void upToDateFollowerShouldNotLoseDataWhenQuorumExperienceCorruption2() throws Exception {
        RaftServer[] servers = (RaftServer[])this.raftRule.getServers().toArray(RaftServer[]::new);
        MemberId node0 = MemberId.from((String)servers[0].name());
        MemberId node1 = MemberId.from((String)servers[1].name());
        MemberId node2 = MemberId.from((String)servers[2].name());
        this.raftRule.appendEntries(200);
        this.raftRule.appendEntries(1);
        Awaitility.await((String)"commitIndex is > 0 on all nodes").until(() -> Arrays.stream(servers).allMatch(s -> s.getContext().getCommitIndex() >= 100L));
        for (RaftServer server : servers) {
            this.raftRule.shutdownServer(server);
        }
        LOGGER.debug("All servers shut down");
        this.raftRule.triggerDataLossOnNode((String)((Object)node0.id()));
        this.raftRule.triggerDataLossOnNode((String)((Object)node1.id()));
        LOGGER.debug("Data loss triggered on Broker-1/Broker-2");
        RaftServer server0 = this.raftRule.createServer(node0);
        RaftServer server1 = this.raftRule.createServer(node1);
        CompletableFuture.allOf(server0.bootstrap(new MemberId[]{node0, node1, node2}), server1.bootstrap(new MemberId[]{node0, node1, node2})).join();
        Awaitility.await((String)"corrupted nodes form a quorum").until(() -> server0.isLeader() || server1.isLeader());
        for (int i = 0; i < 100; ++i) {
            Awaitility.await((String)"entry is committed").untilAsserted(() -> Assertions.assertThatNoException().isThrownBy(() -> this.raftRule.appendEntry()));
        }
        this.raftRule.restartLeader();
        Awaitility.await((String)"until the term is > 1").until(() -> this.raftRule.getLeader().get().getContext().getTerm() > 1L);
        RaftServer server2 = this.raftRule.createServer(node2);
        server2.bootstrap(new MemberId[]{node0, node1, node2});
        this.raftRule.appendEntries(1);
        Awaitility.await((String)"node becomes INACTIVE").until(() -> server2.getRole() == RaftServer.Role.INACTIVE);
    }
}

