/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft;

import io.atomix.raft.RaftApplicationEntryCommittedPositionListener;
import io.atomix.raft.RaftCommitListener;
import io.atomix.raft.RaftRule;
import io.atomix.raft.storage.log.IndexedRaftLogEntry;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class RaftAppendTest {
    @Rule
    @Parameterized.Parameter
    public RaftRule raftRule;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Object[][] raftConfigurations() {
        return new Object[][]{{RaftRule.withBootstrappedNodes(2)}, {RaftRule.withBootstrappedNodes(3)}, {RaftRule.withBootstrappedNodes(4)}, {RaftRule.withBootstrappedNodes(5)}};
    }

    @Test
    public void shouldAppendEntryOnAllNodes() throws Throwable {
        long commitIndex = this.raftRule.appendEntry();
        this.raftRule.awaitCommit(commitIndex);
        this.raftRule.awaitSameLogSizeOnAllNodes(commitIndex);
        Map<String, List<IndexedRaftLogEntry>> memberLog = this.raftRule.getMemberLogs();
        Integer logLength = memberLog.values().stream().map(List::size).findFirst().orElseThrow();
        ((AbstractIntegerAssert)Assertions.assertThat((Integer)logLength).withFailMessage(memberLog.toString(), new Object[0])).isEqualTo(2);
        this.assertMemberLogs(memberLog);
    }

    @Test
    public void shouldNotifyCommitListenerOnAllNodes() throws Throwable {
        RaftCommitListener raftCommitListener = (RaftCommitListener)Mockito.mock(RaftCommitListener.class);
        this.raftRule.addCommitListener(raftCommitListener);
        long commitIndex = this.raftRule.appendEntry();
        ((RaftCommitListener)Mockito.verify((Object)raftCommitListener, (VerificationMode)Mockito.timeout((long)1000L).times(this.raftRule.getNodes().size()))).onCommit(commitIndex);
    }

    @Test
    public void shouldNotifyCommittedEntryListenerOnLeaderOnly() throws Throwable {
        RaftApplicationEntryCommittedPositionListener committedEntryListener = (RaftApplicationEntryCommittedPositionListener)Mockito.mock(RaftApplicationEntryCommittedPositionListener.class);
        this.raftRule.addCommittedEntryListener(committedEntryListener);
        this.raftRule.appendEntry();
        ((RaftApplicationEntryCommittedPositionListener)Mockito.verify((Object)committedEntryListener, (VerificationMode)Mockito.timeout((long)1000L).times(1))).onCommit(ArgumentMatchers.anyLong());
    }

    @Test
    public void shouldAppendEntriesOnAllNodes() throws Throwable {
        int entryCount = 128;
        long lastIndex = this.raftRule.appendEntries(128);
        this.raftRule.awaitSameLogSizeOnAllNodes(lastIndex);
        Map<String, List<IndexedRaftLogEntry>> memberLog = this.raftRule.getMemberLogs();
        Long maxIndex = memberLog.values().stream().flatMap(Collection::stream).map(IndexedRaftLogEntry::index).max(Long::compareTo).orElseThrow();
        Assertions.assertThat((Long)maxIndex).isEqualTo(lastIndex);
        Assertions.assertThat((long)lastIndex).isEqualTo(129L);
        this.assertMemberLogs(memberLog);
    }

    private void assertMemberLogs(Map<String, List<IndexedRaftLogEntry>> memberLog) {
        List<IndexedRaftLogEntry> firstMemberEntries = memberLog.get("1");
        Set<String> members = memberLog.keySet();
        for (String member : members) {
            if (member.equals("1")) continue;
            List<IndexedRaftLogEntry> otherEntries = memberLog.get(member);
            ((ListAssert)Assertions.assertThat(otherEntries).describedAs("Entry comparison 1 vs " + member, new Object[0])).containsExactly((Object[])firstMemberEntries.toArray(new IndexedRaftLogEntry[0]));
        }
    }
}

