/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft;

import io.atomix.raft.RaftRule;
import io.atomix.raft.storage.log.entry.ApplicationEntry;
import io.atomix.raft.zeebe.EntryValidator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;

public final class EntryValidationTest {
    private final TestEntryValidator entryValidator = new TestEntryValidator();
    @Rule
    public RaftRule raftRule = RaftRule.withBootstrappedNodes(3).setEntryValidator(this.entryValidator);

    @Test
    public void shouldValidateEntryWithLastAfterFailOver() throws Exception {
        this.entryValidator.validation = (last, current) -> {
            Assertions.assertThat((Object)last).isNull();
            return EntryValidator.ValidationResult.ok();
        };
        this.raftRule.appendEntry();
        CountDownLatch latch = new CountDownLatch(1);
        this.entryValidator.validation = (last, current) -> {
            Assertions.assertThat((Object)last).isNotNull();
            Assertions.assertThat((long)last.lowestPosition()).isEqualTo(1L);
            Assertions.assertThat((long)last.highestPosition()).isEqualTo(11L);
            latch.countDown();
            return EntryValidator.ValidationResult.ok();
        };
        this.raftRule.shutdownLeader();
        this.raftRule.awaitNewLeader();
        this.raftRule.appendEntry();
        Assertions.assertThat((boolean)latch.await(10L, TimeUnit.SECONDS)).isTrue();
    }

    private static final class TestEntryValidator
    implements EntryValidator {
        BiFunction<ApplicationEntry, ApplicationEntry, EntryValidator.ValidationResult> validation;

        private TestEntryValidator() {
        }

        public EntryValidator.ValidationResult validateEntry(ApplicationEntry lastEntry, ApplicationEntry entry) {
            return this.validation.apply(lastEntry, entry);
        }
    }
}

