/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft;

import io.atomix.cluster.MemberId;
import io.atomix.utils.concurrent.Scheduled;
import io.atomix.utils.concurrent.ScheduledFutureImpl;
import io.atomix.utils.concurrent.ThreadContext;
import java.time.Duration;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.jmock.lib.concurrent.DeterministicScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public final class DeterministicSingleThreadContext
implements ThreadContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeterministicSingleThreadContext.class);
    private final DeterministicScheduler deterministicScheduler;
    private final MemberId memberId;

    public DeterministicSingleThreadContext(DeterministicScheduler executor, MemberId memberId) {
        this.deterministicScheduler = executor;
        this.memberId = memberId;
    }

    public DeterministicScheduler getDeterministicScheduler() {
        return this.deterministicScheduler;
    }

    public static ThreadContext createContext(MemberId memberId) {
        return new DeterministicSingleThreadContext(new DeterministicScheduler(), memberId);
    }

    public Scheduled schedule(long delay, TimeUnit timeUnit, Runnable command) {
        ScheduledFuture future = this.deterministicScheduler.schedule((Runnable)new WrappedRunnable(command), delay, timeUnit);
        return new ScheduledFutureImpl((Future)future);
    }

    public Scheduled schedule(Duration delay, Runnable command) {
        ScheduledFuture future = this.deterministicScheduler.schedule((Runnable)new WrappedRunnable(command), delay.toMillis(), TimeUnit.MILLISECONDS);
        return new ScheduledFutureImpl((Future)future);
    }

    public Scheduled schedule(long initialDelay, long interval, TimeUnit timeUnit, Runnable command) {
        ScheduledFuture future = this.deterministicScheduler.scheduleAtFixedRate((Runnable)new WrappedRunnable(command), initialDelay, interval, timeUnit);
        return new ScheduledFutureImpl((Future)future);
    }

    public Scheduled schedule(Duration initialDelay, Duration interval, Runnable command) {
        ScheduledFuture future = this.deterministicScheduler.scheduleAtFixedRate((Runnable)new WrappedRunnable(command), initialDelay.toMillis(), interval.toMillis(), TimeUnit.MILLISECONDS);
        return new ScheduledFutureImpl((Future)future);
    }

    public void execute(Runnable command) {
        this.deterministicScheduler.execute((Runnable)new WrappedRunnable(command));
    }

    public void checkThread() {
    }

    public void close() {
    }

    private final class WrappedRunnable
    implements Runnable {
        private final Runnable command;

        WrappedRunnable(Runnable command) {
            this.command = command;
        }

        @Override
        public void run() {
            try (MDC.MDCCloseable ignored = MDC.putCloseable((String)"actor-scheduler", (String)DeterministicSingleThreadContext.this.memberId.toString());){
                this.command.run();
            }
            catch (Exception e) {
                LOGGER.error("Uncaught exception", (Throwable)e);
                Assertions.fail((String)("Uncaught exception" + String.valueOf(e)));
            }
        }
    }
}

