/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.atomix.cluster.messaging.ManagedMessagingService;
import io.atomix.cluster.messaging.MessagingException;
import io.atomix.cluster.messaging.MessagingService;
import io.atomix.utils.net.Address;
import java.net.ConnectException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public class TestMessagingService
implements ManagedMessagingService {
    private final Address address;
    private final Map<Address, TestMessagingService> services;
    private final Map<String, BiFunction<Address, byte[], CompletableFuture<byte[]>>> handlers = new ConcurrentHashMap<String, BiFunction<Address, byte[], CompletableFuture<byte[]>>>();
    private final AtomicBoolean started = new AtomicBoolean();
    private final Set<Address> partitions = Sets.newConcurrentHashSet();

    public TestMessagingService(Address address, Map<Address, TestMessagingService> services) {
        this.address = address;
        this.services = services;
    }

    private TestMessagingService getService(Address address) {
        Preconditions.checkNotNull((Object)address);
        return this.services.get(address);
    }

    private BiFunction<Address, byte[], CompletableFuture<byte[]>> getHandler(Address address, String type) {
        TestMessagingService service = this.getService(address);
        if (service == null) {
            return (e, p) -> {
                MessagingException.NoRemoteHandler t = new MessagingException.NoRemoteHandler(type);
                return CompletableFuture.failedFuture((Throwable)t);
            };
        }
        BiFunction<Address, byte[], CompletableFuture<byte[]>> handler = service.handlers.get(Preconditions.checkNotNull((Object)type));
        if (handler == null) {
            return (e, p) -> {
                MessagingException.NoRemoteHandler t = new MessagingException.NoRemoteHandler(type);
                return CompletableFuture.failedFuture((Throwable)t);
            };
        }
        return handler;
    }

    void partition(Address address) {
        this.partitions.add(address);
    }

    void heal(Address address) {
        this.partitions.remove(address);
    }

    boolean isPartitioned(Address address) {
        return this.partitions.contains(address);
    }

    public Address address() {
        return this.address;
    }

    public Collection<Address> bindingAddresses() {
        return List.of(this.address);
    }

    public CompletableFuture<Void> sendAsync(Address address, String type, byte[] payload, boolean keepAlive) {
        if (this.isPartitioned(address)) {
            return CompletableFuture.failedFuture(new ConnectException());
        }
        return this.getHandler(address, type).apply(this.address, payload).thenApply(v -> null);
    }

    public CompletableFuture<byte[]> sendAndReceive(Address address, String type, byte[] payload, boolean keepAlive) {
        if (this.isPartitioned(address)) {
            return CompletableFuture.failedFuture(new ConnectException());
        }
        return this.getHandler(address, type).apply(this.address, payload);
    }

    public CompletableFuture<byte[]> sendAndReceive(Address address, String type, byte[] payload, boolean keepAlive, Executor executor) {
        if (this.isPartitioned(address)) {
            return CompletableFuture.failedFuture(new ConnectException());
        }
        CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
        this.sendAndReceive(address, type, payload).whenCompleteAsync((response, error) -> {
            if (error == null) {
                future.complete((byte[])response);
            } else {
                future.completeExceptionally((Throwable)error);
            }
        }, executor);
        return future;
    }

    public CompletableFuture<byte[]> sendAndReceive(Address address, String type, byte[] payload, boolean keepAlive, Duration timeout) {
        if (this.isPartitioned(address)) {
            return CompletableFuture.failedFuture(new ConnectException());
        }
        return this.getHandler(address, type).apply(this.address, payload);
    }

    public CompletableFuture<byte[]> sendAndReceive(Address address, String type, byte[] payload, boolean keepAlive, Duration timeout, Executor executor) {
        if (this.isPartitioned(address)) {
            return CompletableFuture.failedFuture(new ConnectException());
        }
        CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
        this.sendAndReceive(address, type, payload).whenCompleteAsync((response, error) -> {
            if (error == null) {
                future.complete((byte[])response);
            } else {
                future.completeExceptionally((Throwable)error);
            }
        }, executor);
        return future;
    }

    public void registerHandler(String type, BiConsumer<Address, byte[]> handler, Executor executor) {
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull(handler);
        this.handlers.put(type, (e, p) -> {
            try {
                executor.execute(() -> handler.accept((Address)e, (byte[])p));
                return CompletableFuture.completedFuture(new byte[0]);
            }
            catch (RejectedExecutionException e2) {
                return CompletableFuture.failedFuture(e2);
            }
        });
    }

    public void registerHandler(String type, BiFunction<Address, byte[], byte[]> handler, Executor executor) {
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull(handler);
        this.handlers.put(type, (e, p) -> {
            CompletableFuture future = new CompletableFuture();
            try {
                executor.execute(() -> future.complete((byte[])handler.apply((Address)e, (byte[])p)));
            }
            catch (RejectedExecutionException e2) {
                future.completeExceptionally(e2);
            }
            return future;
        });
    }

    public void registerHandler(String type, BiFunction<Address, byte[], CompletableFuture<byte[]>> handler) {
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull(handler);
        this.handlers.put(type, handler);
    }

    public void unregisterHandler(String type) {
        this.handlers.remove(Preconditions.checkNotNull((Object)type));
    }

    public boolean isRunning() {
        return this.started.get();
    }

    public CompletableFuture<MessagingService> start() {
        this.services.put(this.address, this);
        this.started.set(true);
        return CompletableFuture.completedFuture(this);
    }

    public CompletableFuture<Void> stop() {
        this.services.remove(this.address);
        this.started.set(false);
        return CompletableFuture.completedFuture(null);
    }
}

