/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import io.atomix.cluster.messaging.MessagingException;
import io.atomix.cluster.messaging.impl.MessagingMetrics;
import io.atomix.cluster.messaging.impl.ProtocolRequest;
import io.atomix.cluster.messaging.impl.RemoteClientConnection;
import io.atomix.utils.net.Address;
import io.camunda.zeebe.util.CloseableSilently;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class RemoteClientConnectionTest {
    private SimpleMessagingMetrics simpleMetrics;
    private Channel channel;
    private RemoteClientConnection remoteClientConnection;
    private InetSocketAddress toAddress;

    @BeforeEach
    public void setup() {
        this.channel = (Channel)Mockito.mock(Channel.class);
        this.toAddress = new InetSocketAddress(0);
        Mockito.when((Object)this.channel.remoteAddress()).thenReturn((Object)this.toAddress);
        ChannelFuture channelFuture = (ChannelFuture)Mockito.mock(ChannelFuture.class);
        Mockito.when((Object)this.channel.writeAndFlush(ArgumentMatchers.any())).thenReturn((Object)channelFuture);
        this.simpleMetrics = new SimpleMessagingMetrics();
        this.remoteClientConnection = new RemoteClientConnection((MessagingMetrics)this.simpleMetrics, this.channel);
    }

    @Test
    public void shouldCountForMessage() {
        this.remoteClientConnection.sendAsync(new ProtocolRequest(1L, new Address("", 12345), "subj", "payload".getBytes()));
        String expectedKey = this.simpleMetrics.computeKey(this.toAddress.toString(), "subj");
        ((AbstractIntegerAssert)AssertionsForClassTypes.assertThat((Integer)this.simpleMetrics.messageCount.get(expectedKey)).isNotNull()).isEqualTo(1);
        AssertionsForClassTypes.assertThat((Integer)this.simpleMetrics.reqSize.get(expectedKey)).isEqualTo("payload".getBytes().length);
        AssertionsForClassTypes.assertThat((int)this.simpleMetrics.inFlightRequestCount.size()).isEqualTo(0);
        AssertionsForClassTypes.assertThat((int)this.simpleMetrics.reqRespCount.size()).isEqualTo(0);
    }

    @Test
    public void shouldCountForRequestResponse() {
        this.remoteClientConnection.sendAndReceive(new ProtocolRequest(1L, new Address("", 12345), "subj", "payload".getBytes()));
        String expectedKey = this.simpleMetrics.computeKey(this.toAddress.toString(), "subj");
        AssertionsForClassTypes.assertThat((Integer)this.simpleMetrics.inFlightRequestCount.get(expectedKey)).isEqualTo(1);
        AssertionsForClassTypes.assertThat((Integer)this.simpleMetrics.reqRespCount.get(expectedKey)).isEqualTo(1);
        AssertionsForClassTypes.assertThat((Integer)this.simpleMetrics.reqSize.get(expectedKey)).isEqualTo("payload".getBytes().length);
        AssertionsForClassTypes.assertThat((int)this.simpleMetrics.messageCount.size()).isZero();
    }

    @Test
    public void shouldCountForResponse() {
        CompletableFuture responseFuture = this.remoteClientConnection.sendAndReceive(new ProtocolRequest(1L, new Address("", 12345), "subj", "payload".getBytes()));
        responseFuture.complete("complete".getBytes());
        String expectedKey = this.simpleMetrics.computeKey(this.toAddress.toString(), "subj");
        AssertionsForClassTypes.assertThat((Integer)this.simpleMetrics.inFlightRequestCount.get(expectedKey)).isEqualTo(0);
        AssertionsForClassTypes.assertThat((Integer)this.simpleMetrics.reqRespCount.get(expectedKey)).isEqualTo(1);
        AssertionsForClassTypes.assertThat((Integer)this.simpleMetrics.reqSize.get(expectedKey)).isEqualTo("payload".getBytes().length);
        AssertionsForClassTypes.assertThat((long)this.simpleMetrics.requestResponseLatency).isGreaterThan(0L);
        AssertionsForClassTypes.assertThat((Boolean)this.simpleMetrics.requestOutcome.get(expectedKey)).isTrue();
        AssertionsForClassTypes.assertThat((int)this.simpleMetrics.messageCount.size()).isZero();
    }

    @Test
    public void shouldCountForFailedResponse() {
        CompletableFuture responseFuture = this.remoteClientConnection.sendAndReceive(new ProtocolRequest(1L, new Address("", 12345), "subj", "payload".getBytes()));
        responseFuture.completeExceptionally(new RuntimeException());
        String expectedKey = this.simpleMetrics.computeKey(this.toAddress.toString(), "subj");
        AssertionsForClassTypes.assertThat((Integer)this.simpleMetrics.inFlightRequestCount.get(expectedKey)).isEqualTo(0);
        AssertionsForClassTypes.assertThat((Integer)this.simpleMetrics.reqRespCount.get(expectedKey)).isEqualTo(1);
        AssertionsForClassTypes.assertThat((Integer)this.simpleMetrics.reqSize.get(expectedKey)).isEqualTo("payload".getBytes().length);
        AssertionsForClassTypes.assertThat((long)this.simpleMetrics.requestResponseLatency).isGreaterThan(0L);
        AssertionsForClassTypes.assertThat((Boolean)this.simpleMetrics.requestOutcome.get(expectedKey)).isFalse();
        AssertionsForClassTypes.assertThat((int)this.simpleMetrics.messageCount.size()).isZero();
    }

    @Test
    public void shouldReceiveConnectionClosedExceptionForResponseOnClientClose() {
        CompletableFuture responseFuture = this.remoteClientConnection.sendAndReceive(new ProtocolRequest(1L, new Address("", 12345), "subj", "payload".getBytes()));
        this.remoteClientConnection.close();
        AssertionsForClassTypes.assertThat((CompletableFuture)responseFuture).failsWithin(100L, TimeUnit.MILLISECONDS).withThrowableOfType(ExecutionException.class).withCauseInstanceOf(MessagingException.ConnectionClosed.class).withMessageContaining("Connection").withMessageContaining("was closed");
    }

    private static final class SimpleMessagingMetrics
    implements MessagingMetrics {
        private static final String LABEL_FORMAT = "%s-%s";
        long requestResponseLatency;
        final Map<String, Integer> messageCount = new HashMap<String, Integer>();
        final Map<String, Integer> inFlightRequestCount = new HashMap<String, Integer>();
        final Map<String, Integer> reqRespCount = new HashMap<String, Integer>();
        final Map<String, Integer> reqSize = new HashMap<String, Integer>();
        final Map<String, Boolean> requestOutcome = new HashMap<String, Boolean>();

        private SimpleMessagingMetrics() {
        }

        public CloseableSilently startRequestTimer(String name) {
            long start = System.nanoTime();
            return () -> {
                this.requestResponseLatency = System.nanoTime() - start;
            };
        }

        public void observeRequestSize(String to, String name, int requestSizeInBytes) {
            this.reqSize.put(this.computeKey(to, name), requestSizeInBytes);
        }

        public void countMessage(String to, String name) {
            String key = this.computeKey(to, name);
            Integer integer = this.messageCount.computeIfAbsent(key, s -> 0);
            this.messageCount.put(key, integer + 1);
        }

        public void countRequestResponse(String to, String name) {
            String key = this.computeKey(to, name);
            Integer integer = this.reqRespCount.computeIfAbsent(key, k -> 0);
            this.reqRespCount.put(key, integer + 1);
        }

        public void countSuccessResponse(String address, String name) {
            String key = this.computeKey(address, name);
            this.requestOutcome.put(key, true);
        }

        public void countFailureResponse(String address, String name, String error) {
            String key = this.computeKey(address, name);
            this.requestOutcome.put(key, false);
        }

        public void incInFlightRequests(String address, String topic) {
            String key = this.computeKey(address, topic);
            Integer integer = this.inFlightRequestCount.computeIfAbsent(key, k -> 0);
            this.inFlightRequestCount.put(key, integer + 1);
        }

        public void decInFlightRequests(String address, String topic) {
            String key = this.computeKey(address, topic);
            Integer integer = this.inFlightRequestCount.computeIfAbsent(key, k -> 0);
            this.inFlightRequestCount.put(key, integer - 1);
        }

        String computeKey(String to, String name) {
            return String.format(LABEL_FORMAT, to, name);
        }
    }
}

