/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.impl;

import io.atomix.cluster.BootstrapService;
import io.atomix.cluster.ClusterMembershipEvent;
import io.atomix.cluster.ClusterMembershipEventListener;
import io.atomix.cluster.Member;
import io.atomix.cluster.MemberId;
import io.atomix.cluster.Node;
import io.atomix.cluster.NodeId;
import io.atomix.cluster.TestBootstrapService;
import io.atomix.cluster.TestDiscoveryProvider;
import io.atomix.cluster.discovery.ManagedNodeDiscoveryService;
import io.atomix.cluster.discovery.NodeDiscoveryProvider;
import io.atomix.cluster.impl.DefaultClusterMembershipService;
import io.atomix.cluster.impl.DefaultNodeDiscoveryService;
import io.atomix.cluster.impl.DiscoveryMembershipProtocol;
import io.atomix.cluster.impl.StatefulMember;
import io.atomix.cluster.messaging.MessagingService;
import io.atomix.cluster.messaging.UnicastService;
import io.atomix.cluster.messaging.impl.TestMessagingServiceFactory;
import io.atomix.cluster.messaging.impl.TestUnicastServiceFactory;
import io.atomix.cluster.protocol.GroupMembershipProtocol;
import io.atomix.utils.Version;
import io.atomix.utils.event.AbstractEvent;
import io.atomix.utils.event.EventListener;
import io.atomix.utils.net.Address;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AtomicReferenceAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.CONCURRENT)
final class DefaultClusterMembershipServiceTest {
    private final TestMessagingServiceFactory messagingServiceFactory = new TestMessagingServiceFactory();
    private final TestUnicastServiceFactory unicastServiceFactory = new TestUnicastServiceFactory();
    private final Member localMember = Member.member((String)"0", (String)"localhost:5000");
    private final Version version = Version.from((String)"1.0.0");
    private final BootstrapService bootstrapService = new TestBootstrapService((MessagingService)this.messagingServiceFactory.newMessagingService(this.localMember.address()), (UnicastService)this.unicastServiceFactory.newUnicastService(this.localMember.address()));
    private final TestDiscoveryProvider discoveryProvider = new TestDiscoveryProvider();
    private final ManagedNodeDiscoveryService discoveryService = new DefaultNodeDiscoveryService(this.bootstrapService, (Node)this.localMember, (NodeDiscoveryProvider)this.discoveryProvider);
    private final DiscoveryMembershipProtocol protocol = new DiscoveryMembershipProtocol();

    DefaultClusterMembershipServiceTest() {
    }

    @Test
    void shouldManageDiscoveryService() {
        DefaultClusterMembershipService membershipService = new DefaultClusterMembershipService(this.localMember, this.version, this.discoveryService, this.bootstrapService, (GroupMembershipProtocol)this.protocol);
        membershipService.start().join();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.discoveryService.isRunning()).as("the discovery service is now running", new Object[0])).isTrue();
        membershipService.stop().join();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.discoveryService.isRunning()).as("the discovery service is not running anymore", new Object[0])).isFalse();
    }

    @Test
    void shouldGetLocalMember() {
        DefaultClusterMembershipService membershipService = new DefaultClusterMembershipService(this.localMember, this.version, this.discoveryService, this.bootstrapService, (GroupMembershipProtocol)this.protocol);
        membershipService.start().join();
        StatefulMember expectedMember = new StatefulMember(this.localMember, this.version);
        ((ObjectAssert)Assertions.assertThat((Object)membershipService.getLocalMember()).as("the local member is member 0", new Object[0])).isEqualTo((Object)expectedMember);
        membershipService.stop().join();
    }

    @Test
    void shouldGetMembers() {
        DefaultClusterMembershipService membershipService = new DefaultClusterMembershipService(this.localMember, this.version, this.discoveryService, this.bootstrapService, (GroupMembershipProtocol)this.protocol);
        this.protocol.getMembers().add(Member.member((String)"1", (String)"localhost:5001"));
        membershipService.start().join();
        ((AbstractCollectionAssert)((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)membershipService.getMembers()).as("there should be at least one member", new Object[0])).isNotEmpty()).as("the reported members are exactly the same as the protocol's", new Object[0])).containsExactlyInAnyOrderElementsOf((Iterable)this.protocol.getMembers());
        membershipService.stop().join();
    }

    @Test
    void shouldTrackLocalMemberReachability() {
        DefaultClusterMembershipService membershipService = new DefaultClusterMembershipService(this.localMember, this.version, this.discoveryService, this.bootstrapService, (GroupMembershipProtocol)this.protocol);
        membershipService.start().join();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)membershipService.getLocalMember().isActive()).as("local member is active after starting", new Object[0])).isTrue();
        membershipService.stop().join();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)membershipService.getLocalMember().isActive()).as("local member is not active after stopping", new Object[0])).isFalse();
    }

    @Test
    void shouldTrackReachabilityOfLocalMember() {
        DefaultClusterMembershipService membershipService = new DefaultClusterMembershipService(this.localMember, this.version, this.discoveryService, this.bootstrapService, (GroupMembershipProtocol)this.protocol);
        membershipService.start().join();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)membershipService.getLocalMember().isReachable()).as("local member is reachable after starting", new Object[0])).isTrue();
        membershipService.stop().join();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)membershipService.getLocalMember().isReachable()).as("local member is not reachable after stopping", new Object[0])).isFalse();
    }

    @Test
    void shouldManageGroupMembershipOfLocalMember() {
        DefaultClusterMembershipService membershipService = new DefaultClusterMembershipService(this.localMember, this.version, this.discoveryService, this.bootstrapService, (GroupMembershipProtocol)this.protocol);
        membershipService.start().join();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)this.protocol.getMembers()).as("local member has joined the group protocol", new Object[0])).containsExactly((Object[])new Member[]{membershipService.getLocalMember()});
        membershipService.stop().join();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)this.protocol.getMembers()).as("local member has left the group protocol", new Object[0])).isEmpty();
    }

    @Test
    void shouldForwardGroupEvents() {
        DefaultClusterMembershipService membershipService = new DefaultClusterMembershipService(this.localMember, this.version, this.discoveryService, this.bootstrapService, (GroupMembershipProtocol)this.protocol);
        membershipService.start().join();
        Address nodeAddress = Address.from((String)"localhost", (int)5002);
        AtomicReference receivedEvent = new AtomicReference();
        membershipService.addListener((EventListener)((ClusterMembershipEventListener)receivedEvent::set));
        this.discoveryProvider.join(this.bootstrapService, Node.builder().withId(NodeId.from((String)"1")).withAddress(nodeAddress).build());
        ((AtomicReferenceAssert)Assertions.assertThat(receivedEvent).as("the received event is the same as the one sent", new Object[0])).hasValueSatisfying(event -> Assertions.assertThat((Object)event).extracting(new Function[]{AbstractEvent::type, AbstractEvent::subject}).containsExactly(new Object[]{ClusterMembershipEvent.Type.MEMBER_ADDED, Member.member((MemberId)MemberId.from((String)"1"), (Address)nodeAddress)}));
        membershipService.stop().join();
    }
}

