/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster;

import io.atomix.cluster.BootstrapService;
import io.atomix.cluster.Node;
import io.atomix.cluster.discovery.NodeDiscoveryConfig;
import io.atomix.cluster.discovery.NodeDiscoveryEvent;
import io.atomix.cluster.discovery.NodeDiscoveryEventListener;
import io.atomix.cluster.discovery.NodeDiscoveryProvider;
import io.atomix.utils.event.AbstractListenerManager;
import io.atomix.utils.event.Event;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;

public final class TestDiscoveryProvider
extends AbstractListenerManager<NodeDiscoveryEvent, NodeDiscoveryEventListener>
implements NodeDiscoveryProvider {
    private final Set<Node> nodes = new CopyOnWriteArraySet<Node>();

    public Set<Node> getNodes() {
        return this.nodes;
    }

    public CompletableFuture<Void> join(BootstrapService bootstrap, Node localNode) {
        if (this.nodes.add(localNode)) {
            this.listenerRegistry.process((Event)new NodeDiscoveryEvent(NodeDiscoveryEvent.Type.JOIN, localNode));
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> leave(Node localNode) {
        if (this.nodes.remove(localNode)) {
            this.listenerRegistry.process((Event)new NodeDiscoveryEvent(NodeDiscoveryEvent.Type.LEAVE, localNode));
        }
        return CompletableFuture.completedFuture(null);
    }

    public NodeDiscoveryConfig config() {
        return null;
    }
}

