/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster;

import io.atomix.cluster.AtomixCluster;
import io.atomix.cluster.AtomixClusterBuilder;
import io.atomix.cluster.ClusterConfig;
import io.atomix.cluster.Node;
import io.atomix.cluster.discovery.BootstrapDiscoveryProvider;
import io.atomix.cluster.discovery.NodeDiscoveryProvider;
import io.atomix.utils.net.Address;
import io.camunda.zeebe.test.util.socket.SocketUtil;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import io.netty.util.NetUtil;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.junit.jupiter.api.AutoClose;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class AtomixClusterRule
extends ExternalResource {
    private static final int TIMEOUT_IN_S = 90;
    @AutoClose
    public final MeterRegistry registry = new SimpleMeterRegistry();
    private final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File dataDir;
    private Map<Integer, Address> addressMap;
    private List<AtomixCluster> instances;

    public Statement apply(Statement base, Description description) {
        return this.temporaryFolder.apply(super.apply(base, description), description);
    }

    public void before() throws IOException {
        this.dataDir = this.temporaryFolder.newFolder();
        this.addressMap = new HashMap<Integer, Address>();
        this.instances = new ArrayList<AtomixCluster>();
    }

    protected void after() {
        List<CompletableFuture> futures = this.instances.stream().map(AtomixCluster::stop).collect(Collectors.toList());
        try {
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).get(90L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public AtomixClusterBuilder buildAtomix(int id, List<Integer> memberIds, Properties properties) {
        Collection nodes = memberIds.stream().map(memberId -> {
            Address address = this.getAddress((Integer)memberId);
            return Node.builder().withId(String.valueOf(memberId)).withAddress(address).build();
        }).collect(Collectors.toList());
        return new AtomixClusterBuilder(new ClusterConfig(), this.registry).withClusterId("test").withMemberId(String.valueOf(id)).withHost("localhost").withPort(this.getAddress(id).port()).withProperties(properties).withMembershipProvider((NodeDiscoveryProvider)new BootstrapDiscoveryProvider(nodes));
    }

    private Address getAddress(Integer memberId) {
        return this.addressMap.computeIfAbsent(memberId, newId -> {
            InetSocketAddress nextInetAddress = SocketUtil.getNextAddress();
            String addressString = NetUtil.toSocketAddressString((InetSocketAddress)nextInetAddress);
            return Address.from((String)addressString);
        });
    }

    private AtomixCluster createAtomix(int id, List<Integer> bootstrapIds, Function<AtomixClusterBuilder, AtomixCluster> builderFunction) {
        return this.createAtomix(id, bootstrapIds, new Properties(), builderFunction);
    }

    private AtomixCluster createAtomix(int id, List<Integer> bootstrapIds, Properties properties, Function<AtomixClusterBuilder, AtomixCluster> builderFunction) {
        return builderFunction.apply(this.buildAtomix(id, bootstrapIds, properties));
    }

    public CompletableFuture<AtomixCluster> startAtomix(int id, List<Integer> persistentIds, Function<AtomixClusterBuilder, AtomixCluster> builderFunction) {
        AtomixCluster atomix = this.createAtomix(id, persistentIds, builderFunction);
        this.instances.add(atomix);
        return atomix.start().thenApply(v -> atomix);
    }
}

