/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.log;

import io.atomix.raft.storage.log.IndexedRaftLogEntry;
import io.atomix.raft.storage.log.RaftLog;
import io.atomix.raft.storage.log.RaftLogReader;
import io.atomix.raft.storage.log.entry.RaftEntry;
import io.atomix.raft.storage.log.entry.RaftLogEntry;
import io.atomix.raft.storage.log.entry.SerializedApplicationEntry;
import io.camunda.zeebe.journal.CheckedJournalException;
import io.camunda.zeebe.journal.JournalMetaStore;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.AutoClose;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class RaftLogUncommittedReaderTest {
    private RaftLog raftlog;
    private RaftLogReader uncommittedReader;
    @AutoClose
    private final MeterRegistry meterRegistry = new SimpleMeterRegistry();
    private final ByteBuffer data = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(0, 123456);

    RaftLogUncommittedReaderTest() {
    }

    @BeforeEach
    void setup(@TempDir File directory) {
        this.raftlog = RaftLog.builder((MeterRegistry)this.meterRegistry).withDirectory(directory).withName("test").withMetaStore((JournalMetaStore)new JournalMetaStore.InMemory()).build();
        this.uncommittedReader = this.raftlog.openUncommittedReader();
        this.data.order(ByteOrder.LITTLE_ENDIAN).putInt(123456);
    }

    @AfterEach
    void tearDown() {
        this.uncommittedReader.close();
        this.raftlog.close();
    }

    @Test
    void shouldReadUncommittedEntries() {
        this.appendEntries(2);
        Assertions.assertThat((boolean)this.uncommittedReader.hasNext()).isTrue();
        Assertions.assertThat((long)((IndexedRaftLogEntry)this.uncommittedReader.next()).index()).isEqualTo(1L);
        Assertions.assertThat((boolean)this.uncommittedReader.hasNext()).isTrue();
        Assertions.assertThat((long)((IndexedRaftLogEntry)this.uncommittedReader.next()).index()).isEqualTo(2L);
        Assertions.assertThat((boolean)this.uncommittedReader.hasNext()).isFalse();
    }

    @Test
    void shouldSeekToIndex() {
        this.appendEntries(10);
        long nextIndex = this.uncommittedReader.seek(5L);
        Assertions.assertThat((long)nextIndex).isEqualTo(5L);
        Assertions.assertThat((boolean)this.uncommittedReader.hasNext()).isTrue();
        Assertions.assertThat((long)((IndexedRaftLogEntry)this.uncommittedReader.next()).index()).isEqualTo(5L);
    }

    @Test
    void shouldSeekToIndexAfterTruncate() throws CheckedJournalException {
        this.appendEntries(6);
        this.uncommittedReader.seek(5L);
        this.raftlog.deleteAfter(3L);
        long nextIndex = this.uncommittedReader.seek(5L);
        Assertions.assertThat((long)nextIndex).isEqualTo(4L);
        Assertions.assertThat((boolean)this.uncommittedReader.hasNext()).isFalse();
    }

    @Test
    void shouldSeekToLast() {
        this.appendEntries(5);
        long nextIndex = this.uncommittedReader.seekToLast();
        Assertions.assertThat((long)nextIndex).isEqualTo(5L);
        Assertions.assertThat((boolean)this.uncommittedReader.hasNext()).isTrue();
        Assertions.assertThat((long)((IndexedRaftLogEntry)this.uncommittedReader.next()).index()).isEqualTo(5L);
    }

    @Test
    void shouldSeekToAsqn() {
        this.appendEntries(10);
        long nextIndex = this.uncommittedReader.seekToAsqn(5L);
        Assertions.assertThat((long)nextIndex).isEqualTo(5L);
        Assertions.assertThat((boolean)this.uncommittedReader.hasNext()).isTrue();
        Assertions.assertThat((long)((IndexedRaftLogEntry)this.uncommittedReader.next()).getPersistedRaftRecord().asqn()).isEqualTo(5L);
    }

    @Test
    void shouldSeekToLastAsqn() {
        this.appendEntries(10);
        long nextIndex = this.uncommittedReader.seekToAsqn(Long.MAX_VALUE);
        Assertions.assertThat((long)nextIndex).isEqualTo(10L);
        Assertions.assertThat((boolean)this.uncommittedReader.hasNext()).isTrue();
        Assertions.assertThat((long)((IndexedRaftLogEntry)this.uncommittedReader.next()).getPersistedRaftRecord().asqn()).isEqualTo(10L);
    }

    private void appendEntries(int count) {
        for (int i = 0; i < count; ++i) {
            SerializedApplicationEntry applicationEntry = new SerializedApplicationEntry((long)(i + 1), (long)(i + 1), this.data);
            RaftLogEntry entry = new RaftLogEntry(1L, (RaftEntry)applicationEntry);
            this.raftlog.append(entry);
        }
    }
}

