/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster;

import io.atomix.cluster.AtomixCluster;
import io.atomix.cluster.AtomixClusterBuilder;
import io.atomix.cluster.AtomixClusterRule;
import io.atomix.cluster.Node;
import io.atomix.cluster.discovery.BootstrapDiscoveryProvider;
import io.atomix.utils.net.Address;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;

public class AtomixClusterTest {
    private static final int TIMEOUT_IN_S = 90;
    @Rule
    public final AtomixClusterRule atomixClusterRule = new AtomixClusterRule();

    @Test
    public void testStopStartConsensus() throws Exception {
        AtomixCluster atomix = this.atomixClusterRule.startAtomix(1, Arrays.asList(1), AtomixClusterBuilder::build).get(90L, TimeUnit.SECONDS);
        CompletableFuture stopFuture = atomix.stop();
        Assertions.assertThat((CompletableFuture)stopFuture).succeedsWithin(90L, TimeUnit.SECONDS);
        Assertions.assertThat((CompletableFuture)stopFuture).isDone();
    }

    @Test
    public void shouldFailStartAfterStop() throws Exception {
        AtomixCluster atomix = this.atomixClusterRule.startAtomix(1, Arrays.asList(1), AtomixClusterBuilder::build).get(90L, TimeUnit.SECONDS);
        atomix.stop().get(90L, TimeUnit.SECONDS);
        try {
            atomix.start().get(90L, TimeUnit.SECONDS);
            Assertions.fail((String)"Expected ExecutionException");
        }
        catch (ExecutionException ex) {
            Assertions.assertThat((boolean)(ex.getCause() instanceof IllegalStateException)).isTrue();
            Assertions.assertThat((String)ex.getCause().getMessage()).isEqualTo("Cluster instance is shutdown");
        }
    }

    @Test
    public void testBootstrap() throws Exception {
        List<Node> bootstrapLocations = Arrays.asList(Node.builder().withId("foo").withAddress(Address.from((String)"localhost:5000")).build(), Node.builder().withId("bar").withAddress(Address.from((String)"localhost:5001")).build(), Node.builder().withId("baz").withAddress(Address.from((String)"localhost:5002")).build());
        AtomixCluster cluster1 = AtomixCluster.builder((MeterRegistry)this.atomixClusterRule.registry).withMemberId("foo").withHost("localhost").withPort(5000).withMembershipProvider(BootstrapDiscoveryProvider.builder().withNodes(bootstrapLocations).build()).build();
        cluster1.start().join();
        Assertions.assertThat((String)((String)((Object)cluster1.getMembershipService().getLocalMember().id().id()))).isEqualTo("foo");
        AtomixCluster cluster2 = AtomixCluster.builder((MeterRegistry)this.atomixClusterRule.registry).withMemberId("bar").withHost("localhost").withPort(5001).withMembershipProvider(BootstrapDiscoveryProvider.builder().withNodes(bootstrapLocations).build()).build();
        cluster2.start().join();
        Assertions.assertThat((String)((String)((Object)cluster2.getMembershipService().getLocalMember().id().id()))).isEqualTo("bar");
        AtomixCluster cluster3 = AtomixCluster.builder((MeterRegistry)this.atomixClusterRule.registry).withMemberId("baz").withHost("localhost").withPort(5002).withMembershipProvider(BootstrapDiscoveryProvider.builder().withNodes(bootstrapLocations).build()).build();
        cluster3.start().join();
        Assertions.assertThat((String)((String)((Object)cluster3.getMembershipService().getLocalMember().id().id()))).isEqualTo("baz");
        List<CompletableFuture> futures = Stream.of(cluster1, cluster2, cluster3).map(AtomixCluster::stop).collect(Collectors.toList());
        try {
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

