/* Generated SBE (Simple Binary Encoding) message codec. */
package io.atomix.raft.snapshot.impl;

import org.agrona.MutableDirectBuffer;
import org.agrona.DirectBuffer;
import org.agrona.sbe.*;

@SuppressWarnings("all")
public final class SnapshotChunkDecoder implements MessageDecoderFlyweight
{
    public static final int BLOCK_LENGTH = 36;
    public static final int TEMPLATE_ID = 4;
    public static final int SCHEMA_ID = 6;
    public static final int SCHEMA_VERSION = 3;
    public static final String SEMANTIC_VERSION = "0.1.0";
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final SnapshotChunkDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public DirectBuffer buffer()
    {
        return buffer;
    }

    public int offset()
    {
        return offset;
    }

    public SnapshotChunkDecoder wrap(
        final DirectBuffer buffer,
        final int offset,
        final int actingBlockLength,
        final int actingVersion)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        limit(offset + actingBlockLength);

        return this;
    }

    public SnapshotChunkDecoder wrapAndApplyHeader(
        final DirectBuffer buffer,
        final int offset,
        final MessageHeaderDecoder headerDecoder)
    {
        headerDecoder.wrap(buffer, offset);

        final int templateId = headerDecoder.templateId();
        if (TEMPLATE_ID != templateId)
        {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }

        return wrap(
            buffer,
            offset + MessageHeaderDecoder.ENCODED_LENGTH,
            headerDecoder.blockLength(),
            headerDecoder.version());
    }

    public SnapshotChunkDecoder sbeRewind()
    {
        return wrap(buffer, offset, actingBlockLength, actingVersion);
    }

    public int sbeDecodedLength()
    {
        final int currentLimit = limit();
        sbeSkip();
        final int decodedLength = encodedLength();
        limit(currentLimit);

        return decodedLength;
    }

    public int actingVersion()
    {
        return actingVersion;
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int totalCountId()
    {
        return 0;
    }

    public static int totalCountSinceVersion()
    {
        return 0;
    }

    public static int totalCountEncodingOffset()
    {
        return 0;
    }

    public static int totalCountEncodingLength()
    {
        return 4;
    }

    public static String totalCountMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int totalCountNullValue()
    {
        return -2147483648;
    }

    public static int totalCountMinValue()
    {
        return -2147483647;
    }

    public static int totalCountMaxValue()
    {
        return 2147483647;
    }

    public int totalCount()
    {
        return buffer.getInt(offset + 0, BYTE_ORDER);
    }


    public static int checksumId()
    {
        return 1;
    }

    public static int checksumSinceVersion()
    {
        return 0;
    }

    public static int checksumEncodingOffset()
    {
        return 4;
    }

    public static int checksumEncodingLength()
    {
        return 8;
    }

    public static String checksumMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long checksumNullValue()
    {
        return 0xffffffffffffffffL;
    }

    public static long checksumMinValue()
    {
        return 0x0L;
    }

    public static long checksumMaxValue()
    {
        return 0xfffffffffffffffeL;
    }

    public long checksum()
    {
        return buffer.getLong(offset + 4, BYTE_ORDER);
    }


    public static int snapshotChecksumId()
    {
        return 5;
    }

    public static int snapshotChecksumSinceVersion()
    {
        return 2;
    }

    public static int snapshotChecksumEncodingOffset()
    {
        return 12;
    }

    public static int snapshotChecksumEncodingLength()
    {
        return 8;
    }

    public static String snapshotChecksumMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long snapshotChecksumNullValue()
    {
        return 0xffffffffffffffffL;
    }

    public static long snapshotChecksumMinValue()
    {
        return 0x0L;
    }

    public static long snapshotChecksumMaxValue()
    {
        return 0xfffffffffffffffeL;
    }

    public long snapshotChecksum()
    {
        if (parentMessage.actingVersion < 2)
        {
            return 0xffffffffffffffffL;
        }

        return buffer.getLong(offset + 12, BYTE_ORDER);
    }


    public static int fileBlockPositionId()
    {
        return 6;
    }

    public static int fileBlockPositionSinceVersion()
    {
        return 3;
    }

    public static int fileBlockPositionEncodingOffset()
    {
        return 20;
    }

    public static int fileBlockPositionEncodingLength()
    {
        return 8;
    }

    public static String fileBlockPositionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long fileBlockPositionNullValue()
    {
        return 0xffffffffffffffffL;
    }

    public static long fileBlockPositionMinValue()
    {
        return 0x0L;
    }

    public static long fileBlockPositionMaxValue()
    {
        return 0xfffffffffffffffeL;
    }

    public long fileBlockPosition()
    {
        if (parentMessage.actingVersion < 3)
        {
            return 0xffffffffffffffffL;
        }

        return buffer.getLong(offset + 20, BYTE_ORDER);
    }


    public static int totalFileSizeId()
    {
        return 7;
    }

    public static int totalFileSizeSinceVersion()
    {
        return 3;
    }

    public static int totalFileSizeEncodingOffset()
    {
        return 28;
    }

    public static int totalFileSizeEncodingLength()
    {
        return 8;
    }

    public static String totalFileSizeMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long totalFileSizeNullValue()
    {
        return 0xffffffffffffffffL;
    }

    public static long totalFileSizeMinValue()
    {
        return 0x0L;
    }

    public static long totalFileSizeMaxValue()
    {
        return 0xfffffffffffffffeL;
    }

    public long totalFileSize()
    {
        if (parentMessage.actingVersion < 3)
        {
            return 0xffffffffffffffffL;
        }

        return buffer.getLong(offset + 28, BYTE_ORDER);
    }


    public static int snapshotIdId()
    {
        return 2;
    }

    public static int snapshotIdSinceVersion()
    {
        return 0;
    }

    public static String snapshotIdCharacterEncoding()
    {
        return java.nio.charset.StandardCharsets.UTF_8.name();
    }

    public static String snapshotIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int snapshotIdHeaderLength()
    {
        return 4;
    }

    public int snapshotIdLength()
    {
        final int limit = parentMessage.limit();
        return (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
    }

    public int skipSnapshotId()
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        final int dataOffset = limit + headerLength;
        parentMessage.limit(dataOffset + dataLength);

        return dataLength;
    }

    public int getSnapshotId(final MutableDirectBuffer dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public int getSnapshotId(final byte[] dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public void wrapSnapshotId(final DirectBuffer wrapBuffer)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        parentMessage.limit(limit + headerLength + dataLength);
        wrapBuffer.wrap(buffer, limit + headerLength, dataLength);
    }

    public String snapshotId()
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        parentMessage.limit(limit + headerLength + dataLength);

        if (0 == dataLength)
        {
            return "";
        }

        final byte[] tmp = new byte[dataLength];
        buffer.getBytes(limit + headerLength, tmp, 0, dataLength);

        return new String(tmp, java.nio.charset.StandardCharsets.UTF_8);
    }

    public static int chunkNameId()
    {
        return 3;
    }

    public static int chunkNameSinceVersion()
    {
        return 0;
    }

    public static String chunkNameCharacterEncoding()
    {
        return java.nio.charset.StandardCharsets.UTF_8.name();
    }

    public static String chunkNameMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int chunkNameHeaderLength()
    {
        return 4;
    }

    public int chunkNameLength()
    {
        final int limit = parentMessage.limit();
        return (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
    }

    public int skipChunkName()
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        final int dataOffset = limit + headerLength;
        parentMessage.limit(dataOffset + dataLength);

        return dataLength;
    }

    public int getChunkName(final MutableDirectBuffer dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public int getChunkName(final byte[] dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public void wrapChunkName(final DirectBuffer wrapBuffer)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        parentMessage.limit(limit + headerLength + dataLength);
        wrapBuffer.wrap(buffer, limit + headerLength, dataLength);
    }

    public String chunkName()
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        parentMessage.limit(limit + headerLength + dataLength);

        if (0 == dataLength)
        {
            return "";
        }

        final byte[] tmp = new byte[dataLength];
        buffer.getBytes(limit + headerLength, tmp, 0, dataLength);

        return new String(tmp, java.nio.charset.StandardCharsets.UTF_8);
    }

    public static int contentId()
    {
        return 4;
    }

    public static int contentSinceVersion()
    {
        return 0;
    }

    public static String contentMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int contentHeaderLength()
    {
        return 4;
    }

    public int contentLength()
    {
        final int limit = parentMessage.limit();
        return (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
    }

    public int skipContent()
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        final int dataOffset = limit + headerLength;
        parentMessage.limit(dataOffset + dataLength);

        return dataLength;
    }

    public int getContent(final MutableDirectBuffer dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public int getContent(final byte[] dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public void wrapContent(final DirectBuffer wrapBuffer)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        parentMessage.limit(limit + headerLength + dataLength);
        wrapBuffer.wrap(buffer, limit + headerLength, dataLength);
    }

    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        final SnapshotChunkDecoder decoder = new SnapshotChunkDecoder();
        decoder.wrap(buffer, offset, actingBlockLength, actingVersion);

        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final int originalLimit = limit();
        limit(offset + actingBlockLength);
        builder.append("[SnapshotChunk](sbeTemplateId=");
        builder.append(TEMPLATE_ID);
        builder.append("|sbeSchemaId=");
        builder.append(SCHEMA_ID);
        builder.append("|sbeSchemaVersion=");
        if (parentMessage.actingVersion != SCHEMA_VERSION)
        {
            builder.append(parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(SCHEMA_VERSION);
        builder.append("|sbeBlockLength=");
        if (actingBlockLength != BLOCK_LENGTH)
        {
            builder.append(actingBlockLength);
            builder.append('/');
        }
        builder.append(BLOCK_LENGTH);
        builder.append("):");
        builder.append("totalCount=");
        builder.append(this.totalCount());
        builder.append('|');
        builder.append("checksum=");
        builder.append(this.checksum());
        builder.append('|');
        builder.append("snapshotChecksum=");
        builder.append(this.snapshotChecksum());
        builder.append('|');
        builder.append("fileBlockPosition=");
        builder.append(this.fileBlockPosition());
        builder.append('|');
        builder.append("totalFileSize=");
        builder.append(this.totalFileSize());
        builder.append('|');
        builder.append("snapshotId=");
        builder.append('\'').append(snapshotId()).append('\'');
        builder.append('|');
        builder.append("chunkName=");
        builder.append('\'').append(chunkName()).append('\'');
        builder.append('|');
        builder.append("content=");
        builder.append(skipContent()).append(" bytes of raw data");

        limit(originalLimit);

        return builder;
    }
    
    public SnapshotChunkDecoder sbeSkip()
    {
        sbeRewind();
        skipSnapshotId();
        skipChunkName();
        skipContent();

        return this;
    }
}
