/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.log;

import io.atomix.cluster.MemberId;
import io.atomix.raft.cluster.RaftMember;
import io.atomix.raft.cluster.impl.DefaultRaftMember;
import io.atomix.raft.protocol.ReplicatableJournalRecord;
import io.atomix.raft.storage.log.IndexedRaftLogEntry;
import io.atomix.raft.storage.log.RaftLog;
import io.atomix.raft.storage.log.RaftLogFlusher;
import io.atomix.raft.storage.log.RaftLogReader;
import io.atomix.raft.storage.log.entry.ApplicationEntry;
import io.atomix.raft.storage.log.entry.ConfigurationEntry;
import io.atomix.raft.storage.log.entry.InitialEntry;
import io.atomix.raft.storage.log.entry.RaftEntry;
import io.atomix.raft.storage.log.entry.RaftLogEntry;
import io.atomix.raft.storage.log.entry.SerializedApplicationEntry;
import io.camunda.zeebe.journal.CheckedJournalException;
import io.camunda.zeebe.journal.Journal;
import io.camunda.zeebe.journal.JournalMetaStore;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Instant;
import java.util.Collection;
import java.util.Set;
import org.agrona.concurrent.UnsafeBuffer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.AutoClose;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class RaftLogTest {
    private static final long DEFAULT_APPLICATION_ENTRY_LENGTH = 2L;
    @AutoClose
    private final MeterRegistry meterRegistry = new SimpleMeterRegistry();
    private final InitialEntry initialEntry = new InitialEntry();
    private final ConfigurationEntry configurationEntry = new ConfigurationEntry(1234L, Set.of(new DefaultRaftMember(MemberId.from((String)"0"), RaftMember.Type.ACTIVE, Instant.ofEpochSecond(1234L))));
    private final ByteBuffer data = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putInt(0, 123456);
    private final ApplicationEntry firstApplicationEntry = this.createApplicationEntry(1L);
    private RaftLog raftlog;
    private JournalMetaStore metaStore;
    private RaftLogReader reader;

    RaftLogTest() {
    }

    @BeforeEach
    void setup(@TempDir File directory) {
        this.metaStore = new JournalMetaStore.InMemory();
        this.raftlog = RaftLog.builder((MeterRegistry)this.meterRegistry).withDirectory(directory).withName("test").withMetaStore(this.metaStore).build();
        this.reader = this.raftlog.openUncommittedReader();
    }

    @AfterEach
    void tearDown() {
        this.reader.close();
        this.raftlog.close();
    }

    @Test
    void shouldAppendInitialEntry() {
        RaftLogEntry entry = new RaftLogEntry(1L, (RaftEntry)this.initialEntry);
        IndexedRaftLogEntry appended = this.raftlog.append(entry);
        Assertions.assertThat((boolean)this.reader.hasNext()).isTrue();
        IndexedRaftLogEntry entryRead = (IndexedRaftLogEntry)this.reader.next();
        Assertions.assertThat((long)entryRead.term()).isEqualTo(1L);
        Assertions.assertThat((Object)entryRead.entry()).isInstanceOf(InitialEntry.class);
        Assertions.assertThat((Object)appended).isEqualTo((Object)entryRead);
    }

    @Test
    void shouldAppendConfigurationEntry() {
        RaftLogEntry entry = new RaftLogEntry(1L, (RaftEntry)this.configurationEntry);
        this.raftlog.append(entry);
        Assertions.assertThat((boolean)this.reader.hasNext()).isTrue();
        IndexedRaftLogEntry entryRead = (IndexedRaftLogEntry)this.reader.next();
        Assertions.assertThat((long)entryRead.term()).isEqualTo(1L);
        Assertions.assertThat((Object)entryRead.entry()).isInstanceOf(ConfigurationEntry.class);
        ConfigurationEntry configurationRead = (ConfigurationEntry)entryRead.entry();
        Assertions.assertThat((Collection)configurationRead.newMembers()).containsExactlyInAnyOrderElementsOf((Iterable)this.configurationEntry.newMembers());
        Assertions.assertThat((long)configurationRead.timestamp()).isEqualTo(this.configurationEntry.timestamp());
    }

    @Test
    void shouldAppendApplicationEntry() {
        RaftLogEntry entry = new RaftLogEntry(1L, (RaftEntry)this.firstApplicationEntry);
        IndexedRaftLogEntry appended = this.raftlog.append(entry);
        Assertions.assertThat((boolean)this.reader.hasNext()).isTrue();
        IndexedRaftLogEntry entryRead = (IndexedRaftLogEntry)this.reader.next();
        Assertions.assertThat((long)entryRead.term()).isEqualTo(1L);
        Assertions.assertThat((boolean)entryRead.isApplicationEntry()).isTrue();
        Assertions.assertThat((long)entryRead.getApplicationEntry().lowestPosition()).isEqualTo(1L);
        Assertions.assertThat((long)entryRead.getApplicationEntry().highestPosition()).isEqualTo(2L);
        Assertions.assertThat((Comparable)((SerializedApplicationEntry)entryRead.getApplicationEntry()).data()).isEqualTo((Object)new UnsafeBuffer(this.data));
        Assertions.assertThat((Object)appended).isEqualTo((Object)entryRead);
    }

    @Test
    void shouldUpdateLastAppendedEntry() {
        RaftLogEntry entry = new RaftLogEntry(1L, (RaftEntry)this.firstApplicationEntry);
        IndexedRaftLogEntry appended = this.raftlog.append(entry);
        Assertions.assertThat((Object)this.raftlog.getLastEntry()).isEqualTo((Object)appended);
    }

    @Test
    void shouldAppendReplicatableJournalRecord(@TempDir File directory) {
        RaftLogEntry entry = new RaftLogEntry(1L, (RaftEntry)this.firstApplicationEntry);
        ReplicatableJournalRecord persistedRaftRecord = this.raftlog.append(entry).getReplicatableJournalRecord();
        RaftLog raftlogFollower = RaftLog.builder((MeterRegistry)this.meterRegistry).withDirectory(directory).withName("test-follower").withMetaStore((JournalMetaStore)new JournalMetaStore.InMemory()).build();
        IndexedRaftLogEntry appended = raftlogFollower.append(persistedRaftRecord);
        Assertions.assertThat((Object)raftlogFollower.getLastEntry()).isEqualTo((Object)appended);
        Assertions.assertThat((long)appended.index()).isEqualTo(1L);
        Assertions.assertThat((Object)appended.entry()).isEqualTo((Object)this.firstApplicationEntry);
        Assertions.assertThat((long)appended.getPersistedRaftRecord().asqn()).isEqualTo(this.firstApplicationEntry.lowestPosition());
        raftlogFollower.close();
    }

    @Test
    void shouldDeleteAfter() throws CheckedJournalException {
        this.raftlog.append(new RaftLogEntry(1L, (RaftEntry)this.firstApplicationEntry));
        IndexedRaftLogEntry secondEntry = this.raftlog.append(new RaftLogEntry(1L, (RaftEntry)this.createApplicationEntryAfter(this.firstApplicationEntry)));
        this.raftlog.append(new RaftLogEntry(1L, (RaftEntry)this.createApplicationEntryAfter(secondEntry.getApplicationEntry())));
        this.raftlog.deleteAfter(secondEntry.index());
        Assertions.assertThat((long)this.raftlog.getLastIndex()).isEqualTo(secondEntry.index());
        Assertions.assertThat((Object)this.raftlog.getLastEntry()).isEqualTo((Object)secondEntry);
        Assertions.assertThat((long)this.metaStore.loadLastFlushedIndex()).isEqualTo(secondEntry.index());
    }

    @Test
    void shouldNotDeleteCommittedEntries() {
        this.raftlog.append(new RaftLogEntry(1L, (RaftEntry)this.firstApplicationEntry));
        ApplicationEntry secondApplicationEntry = this.createApplicationEntryAfter(this.firstApplicationEntry);
        long deleteIndex = this.raftlog.append(new RaftLogEntry(1L, (RaftEntry)secondApplicationEntry)).index();
        long commitIndex = this.raftlog.append(new RaftLogEntry(1L, (RaftEntry)this.createApplicationEntryAfter(secondApplicationEntry))).index();
        this.raftlog.setCommitIndex(commitIndex);
        Assertions.assertThatThrownBy(() -> this.raftlog.deleteAfter(deleteIndex)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void shouldReset() {
        this.raftlog.append(new RaftLogEntry(1L, (RaftEntry)this.firstApplicationEntry));
        IndexedRaftLogEntry secondEntry = this.raftlog.append(new RaftLogEntry(1L, (RaftEntry)this.createApplicationEntryAfter(this.firstApplicationEntry)));
        this.raftlog.append(new RaftLogEntry(1L, (RaftEntry)this.createApplicationEntryAfter(secondEntry.getApplicationEntry())));
        this.raftlog.reset(10L);
        Assertions.assertThat((long)this.raftlog.getLastIndex()).isEqualTo(9L);
        Assertions.assertThat((Object)this.raftlog.getLastEntry()).isNull();
        Assertions.assertThat((long)this.raftlog.getFirstIndex()).isEqualTo(10L);
    }

    @Test
    void shouldSetCommitIndex() {
        this.raftlog.setCommitIndex(10L);
        Assertions.assertThat((long)this.raftlog.getCommitIndex()).isEqualTo(10L);
    }

    private ApplicationEntry createApplicationEntryAfter(ApplicationEntry applicationEntry) {
        return this.createApplicationEntry(applicationEntry.highestPosition() + 1L);
    }

    private ApplicationEntry createApplicationEntry(long lowestPosition) {
        return new SerializedApplicationEntry(lowestPosition, lowestPosition + 2L - 1L, this.data);
    }

    @Nested
    final class FlushTest {
        FlushTest(RaftLogTest this$0) {
        }

        @Test
        void shouldUseFlusher() throws CheckedJournalException {
            Journal journal = (Journal)Mockito.mock(Journal.class);
            RaftLogFlusher flusher = (RaftLogFlusher)Mockito.mock(RaftLogFlusher.class);
            RaftLog log = new RaftLog(journal, flusher);
            log.flush();
            ((RaftLogFlusher)Mockito.verify((Object)flusher, (VerificationMode)Mockito.times((int)1))).flush(journal);
        }

        @Test
        void shouldForceFlush() throws CheckedJournalException {
            Journal journal = (Journal)Mockito.mock(Journal.class);
            RaftLogFlusher flusher = (RaftLogFlusher)Mockito.mock(RaftLogFlusher.class);
            RaftLog log = new RaftLog(journal, flusher);
            Mockito.when((Object)journal.getLastIndex()).thenReturn((Object)3L);
            log.forceFlush();
            ((Journal)Mockito.verify((Object)journal, (VerificationMode)Mockito.times((int)1))).flush();
        }

        @Test
        void shouldFlushDirectly() throws CheckedJournalException {
            Journal journal = (Journal)Mockito.mock(Journal.class);
            RaftLog log = new RaftLog(journal, (RaftLogFlusher)new RaftLogFlusher.DirectFlusher());
            Mockito.when((Object)journal.getLastIndex()).thenReturn((Object)3L);
            log.flush();
            ((Journal)Mockito.verify((Object)journal, (VerificationMode)Mockito.times((int)1))).flush();
        }

        @Test
        void shouldDisableFlush() throws CheckedJournalException {
            Journal journal = (Journal)Mockito.mock(Journal.class);
            RaftLogFlusher.NoopFlusher flusher = (RaftLogFlusher.NoopFlusher)Mockito.spy((Object)new RaftLogFlusher.NoopFlusher());
            RaftLog log = new RaftLog(journal, (RaftLogFlusher)flusher);
            log.flush();
            ((RaftLogFlusher.NoopFlusher)Mockito.verify((Object)flusher, (VerificationMode)Mockito.times((int)1))).flush(journal);
            ((Journal)Mockito.verify((Object)journal, (VerificationMode)Mockito.never())).flush();
        }
    }
}

