/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.atomix.cluster.messaging.ManagedUnicastService;
import io.atomix.cluster.messaging.UnicastService;
import io.atomix.utils.net.Address;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;

public class TestUnicastService
implements ManagedUnicastService {
    private final Address address;
    private final Map<Address, TestUnicastService> services;
    private final Map<String, Map<BiConsumer<Address, byte[]>, Executor>> listeners = Maps.newConcurrentMap();
    private final AtomicBoolean started = new AtomicBoolean();
    private final Set<Address> partitions = Sets.newConcurrentHashSet();

    public TestUnicastService(Address address, Map<Address, TestUnicastService> services) {
        this.address = address;
        this.services = services;
    }

    Address address() {
        return this.address;
    }

    void partition(Address address) {
        this.partitions.add(address);
    }

    void heal(Address address) {
        this.partitions.remove(address);
    }

    boolean isPartitioned(Address address) {
        return this.partitions.contains(address);
    }

    public void unicast(Address address, String subject, byte[] message) {
        Map<BiConsumer<Address, byte[]>, Executor> listeners;
        if (this.isPartitioned(address)) {
            return;
        }
        TestUnicastService service = this.services.get(address);
        if (service != null && (listeners = service.listeners.get(subject)) != null) {
            listeners.forEach((listener, executor) -> executor.execute(() -> listener.accept(this.address, message)));
        }
    }

    public synchronized void addListener(String subject, BiConsumer<Address, byte[]> listener, Executor executor) {
        this.listeners.computeIfAbsent(subject, s -> Maps.newConcurrentMap()).put(listener, executor);
    }

    public synchronized void removeListener(String subject, BiConsumer<Address, byte[]> listener) {
        Map<BiConsumer<Address, byte[]>, Executor> listeners = this.listeners.get(subject);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.listeners.remove(subject);
            }
        }
    }

    public CompletableFuture<UnicastService> start() {
        this.services.put(this.address, this);
        this.started.set(true);
        return CompletableFuture.completedFuture(this);
    }

    public boolean isRunning() {
        return this.started.get();
    }

    public CompletableFuture<Void> stop() {
        this.services.remove(this.address);
        this.started.set(false);
        return CompletableFuture.completedFuture(null);
    }
}

