/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.utils;

import io.atomix.cluster.MemberId;
import io.atomix.raft.utils.SimpleVoteQuorum;
import io.atomix.raft.utils.VoteQuorum;
import java.util.Collection;
import java.util.function.Consumer;

public class JointConsensusVoteQuorum
implements VoteQuorum {
    private final SimpleVoteQuorum oldQuorum;
    private final SimpleVoteQuorum newQuorum;
    private final Consumer<Boolean> callback;
    private State oldState = State.Pending;
    private State newState = State.Pending;
    private boolean completed;

    public JointConsensusVoteQuorum(Consumer<Boolean> callback, Collection<MemberId> oldMembers, Collection<MemberId> newMembers) {
        this.oldQuorum = new SimpleVoteQuorum(this::finishOldQuorum, oldMembers);
        this.newQuorum = new SimpleVoteQuorum(this::finishNewQuorum, newMembers);
        this.callback = callback;
    }

    private void finishOldQuorum(Boolean succeeded) {
        this.oldState = succeeded != false ? State.Succeeded : State.Failed;
        this.checkComplete();
    }

    private void finishNewQuorum(Boolean succeeded) {
        this.newState = succeeded != false ? State.Succeeded : State.Failed;
        this.checkComplete();
    }

    private void checkComplete() {
        if (this.completed) {
            return;
        }
        if (this.oldState == State.Succeeded && this.newState == State.Succeeded) {
            this.completed = true;
            this.callback.accept(true);
        } else if (this.oldState == State.Failed || this.newState == State.Failed) {
            this.completed = true;
            this.callback.accept(false);
        }
    }

    @Override
    public void succeed(MemberId member) {
        this.oldQuorum.succeed(member);
        this.newQuorum.succeed(member);
    }

    @Override
    public void fail(MemberId member) {
        this.oldQuorum.fail(member);
        this.newQuorum.fail(member);
    }

    @Override
    public void cancel() {
        this.completed = true;
        this.oldQuorum.cancel();
        this.newQuorum.cancel();
    }

    static enum State {
        Pending,
        Succeeded,
        Failed;

    }
}

