/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.serializer;

import io.atomix.cluster.MemberId;
import io.atomix.raft.cluster.RaftMember;
import io.atomix.raft.cluster.impl.DefaultRaftMember;
import io.atomix.raft.storage.serializer.BooleanType;
import io.atomix.raft.storage.serializer.ConfigurationDecoder;
import io.atomix.raft.storage.serializer.ConfigurationEncoder;
import io.atomix.raft.storage.serializer.MessageHeaderDecoder;
import io.atomix.raft.storage.serializer.MessageHeaderEncoder;
import io.atomix.raft.storage.serializer.MetaDecoder;
import io.atomix.raft.storage.serializer.MetaEncoder;
import io.atomix.raft.storage.serializer.SerializerUtil;
import io.atomix.raft.storage.system.Configuration;
import java.time.Instant;
import java.util.ArrayList;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class MetaStoreSerializer {
    private final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    private final ConfigurationEncoder configurationEncoder = new ConfigurationEncoder();
    private final MetaEncoder metaEncoder = new MetaEncoder();
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final ConfigurationDecoder configurationDecoder = new ConfigurationDecoder();
    private final MetaDecoder metaDecoder = new MetaDecoder();

    public int writeConfiguration(Configuration configuration, MutableDirectBuffer buffer, int offset) {
        this.headerEncoder.wrap(buffer, offset).blockLength(this.configurationEncoder.sbeBlockLength()).templateId(this.configurationEncoder.sbeTemplateId()).schemaId(this.configurationEncoder.sbeSchemaId()).version(this.configurationEncoder.sbeSchemaVersion());
        this.configurationEncoder.wrap(buffer, offset + this.headerEncoder.encodedLength());
        this.configurationEncoder.index(configuration.index()).term(configuration.term()).timestamp(configuration.time()).force(configuration.force() ? BooleanType.TRUE : BooleanType.FALSE);
        ConfigurationEncoder.NewMembersEncoder newMembersEncoder = this.configurationEncoder.newMembersCount(configuration.newMembers().size());
        for (RaftMember member : configuration.newMembers()) {
            String memberId = (String)((Object)member.memberId().id());
            newMembersEncoder.next().type(SerializerUtil.getSBEType(member.getType())).updated(member.getLastUpdated().toEpochMilli()).memberId(memberId);
        }
        ConfigurationEncoder.OldMembersEncoder oldMembersEncoder = this.configurationEncoder.oldMembersCount(configuration.oldMembers().size());
        for (RaftMember member : configuration.oldMembers()) {
            String memberId = (String)((Object)member.memberId().id());
            oldMembersEncoder.next().type(SerializerUtil.getSBEType(member.getType())).updated(member.getLastUpdated().toEpochMilli()).memberId(memberId);
        }
        return this.headerEncoder.encodedLength() + this.configurationEncoder.encodedLength();
    }

    public Configuration readConfiguration(DirectBuffer buffer, int offset) {
        this.headerDecoder.wrap(buffer, offset);
        if (this.headerDecoder.version() != this.configurationEncoder.sbeSchemaVersion() || this.headerDecoder.templateId() != this.configurationEncoder.sbeTemplateId()) {
            return null;
        }
        this.configurationDecoder.wrap(buffer, offset + this.headerDecoder.encodedLength(), this.headerDecoder.blockLength(), this.headerDecoder.version());
        long index = this.configurationDecoder.index();
        long term = this.configurationDecoder.term();
        long timestamp = this.configurationDecoder.timestamp();
        boolean force = BooleanType.TRUE.equals((Object)this.configurationDecoder.force());
        ConfigurationDecoder.NewMembersDecoder newMembersDecoder = this.configurationDecoder.newMembers();
        ArrayList<RaftMember> newMembers = new ArrayList<RaftMember>(newMembersDecoder.count());
        for (ConfigurationDecoder.NewMembersDecoder member : newMembersDecoder) {
            RaftMember.Type type = SerializerUtil.getRaftMemberType(member.type());
            Instant updated = Instant.ofEpochMilli(member.updated());
            String memberId = member.memberId();
            newMembers.add(new DefaultRaftMember(MemberId.from(memberId), type, updated));
        }
        ConfigurationDecoder.OldMembersDecoder oldMembersDecoder = this.configurationDecoder.oldMembers();
        ArrayList<RaftMember> oldMembers = new ArrayList<RaftMember>(oldMembersDecoder.count());
        for (ConfigurationDecoder.OldMembersDecoder member : oldMembersDecoder) {
            RaftMember.Type type = SerializerUtil.getRaftMemberType(member.type());
            Instant updated = Instant.ofEpochMilli(member.updated());
            String memberId = member.memberId();
            oldMembers.add(new DefaultRaftMember(MemberId.from(memberId), type, updated));
        }
        return new Configuration(index, term, timestamp, newMembers, oldMembers, force);
    }

    public void writeTerm(long term, MutableDirectBuffer buffer, int offset) {
        this.headerEncoder.wrap(buffer, offset).blockLength(this.metaEncoder.sbeBlockLength()).templateId(this.metaEncoder.sbeTemplateId()).schemaId(this.metaEncoder.sbeSchemaId()).version(this.metaEncoder.sbeSchemaVersion());
        this.metaEncoder.wrap(buffer, offset + this.headerEncoder.encodedLength());
        this.metaEncoder.term(term);
    }

    public long readTerm(MutableDirectBuffer buffer, int offset) {
        this.headerDecoder.wrap((DirectBuffer)buffer, offset);
        this.metaDecoder.wrap((DirectBuffer)buffer, offset + this.headerDecoder.encodedLength(), this.headerDecoder.blockLength(), this.headerDecoder.version());
        return this.metaDecoder.term();
    }

    public void writeVotedFor(String memberId, MutableDirectBuffer buffer, int offset) {
        this.headerEncoder.wrap(buffer, offset).blockLength(this.metaEncoder.sbeBlockLength()).templateId(this.metaEncoder.sbeTemplateId()).schemaId(this.metaEncoder.sbeSchemaId()).version(this.metaEncoder.sbeSchemaVersion());
        this.metaEncoder.wrap(buffer, offset + this.headerEncoder.encodedLength());
        this.metaEncoder.votedFor(memberId);
    }

    public String readVotedFor(MutableDirectBuffer buffer, int offset) {
        this.headerDecoder.wrap((DirectBuffer)buffer, offset);
        this.metaDecoder.wrap((DirectBuffer)buffer, offset + this.headerDecoder.encodedLength(), this.headerDecoder.blockLength(), this.headerDecoder.version());
        return this.metaDecoder.votedFor();
    }

    public long readLastFlushedIndex(MutableDirectBuffer buffer, int offset) {
        this.headerDecoder.wrap((DirectBuffer)buffer, offset);
        this.metaDecoder.wrap((DirectBuffer)buffer, offset + this.headerDecoder.encodedLength(), this.headerDecoder.blockLength(), this.headerDecoder.version());
        return this.metaDecoder.lastFlushedIndex();
    }

    public void writeLastFlushedIndex(long index, MutableDirectBuffer buffer, int offset) {
        this.headerEncoder.wrap(buffer, offset).blockLength(this.metaEncoder.sbeBlockLength()).templateId(this.metaEncoder.sbeTemplateId()).schemaId(this.metaEncoder.sbeSchemaId()).version(this.metaEncoder.sbeSchemaVersion());
        this.metaEncoder.wrap(buffer, offset + this.headerEncoder.encodedLength());
        this.metaEncoder.lastFlushedIndex(index);
    }
}

