/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.log;

import io.atomix.raft.storage.log.RaftLog;
import io.atomix.raft.storage.log.RaftLogFlusher;
import io.atomix.utils.Builder;
import io.camunda.zeebe.journal.Journal;
import io.camunda.zeebe.journal.JournalMetaStore;
import io.camunda.zeebe.journal.file.SegmentedJournal;
import io.camunda.zeebe.journal.file.SegmentedJournalBuilder;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.File;

public class RaftLogBuilder
implements Builder<RaftLog> {
    private final SegmentedJournalBuilder journalBuilder;
    private RaftLogFlusher flusher = RaftLogFlusher.Factory.DIRECT;

    protected RaftLogBuilder(MeterRegistry meterRegistry) {
        this.journalBuilder = SegmentedJournal.builder((MeterRegistry)meterRegistry);
    }

    public RaftLogBuilder withName(String name) {
        this.journalBuilder.withName(name);
        return this;
    }

    public RaftLogBuilder withDirectory(File directory) {
        this.journalBuilder.withDirectory(directory);
        return this;
    }

    public RaftLogBuilder withMaxSegmentSize(int maxSegmentSize) {
        this.journalBuilder.withMaxSegmentSize(maxSegmentSize);
        return this;
    }

    public RaftLogBuilder withFreeDiskSpace(long freeDiskSpace) {
        this.journalBuilder.withFreeDiskSpace(freeDiskSpace);
        return this;
    }

    public RaftLogBuilder withFlusher(RaftLogFlusher flusher) {
        this.flusher = flusher;
        return this;
    }

    public RaftLogBuilder withJournalIndexDensity(int journalIndexDensity) {
        this.journalBuilder.withJournalIndexDensity(journalIndexDensity);
        return this;
    }

    public RaftLogBuilder withPreallocateSegmentFiles(boolean preallocateSegmentFiles) {
        this.journalBuilder.withPreallocateSegmentFiles(preallocateSegmentFiles);
        return this;
    }

    public RaftLogBuilder withPartitionId(int partitionId) {
        this.journalBuilder.withPartitionId(partitionId);
        return this;
    }

    public RaftLogBuilder withMetaStore(JournalMetaStore metaStore) {
        this.journalBuilder.withMetaStore(metaStore);
        return this;
    }

    public RaftLog build() {
        SegmentedJournal journal = this.journalBuilder.build();
        return new RaftLog((Journal)journal, this.flusher);
    }
}

