/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.protocol;

import io.atomix.raft.protocol.ReplicatableRaftRecord;
import java.util.Arrays;

public record ReplicatableJournalRecord(long term, long index, long checksum, byte[] serializedJournalRecord) implements ReplicatableRaftRecord
{
    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicatableJournalRecord that = (ReplicatableJournalRecord)o;
        if (this.term != that.term) {
            return false;
        }
        if (this.index != that.index) {
            return false;
        }
        if (this.checksum != that.checksum) {
            return false;
        }
        return Arrays.equals(this.serializedJournalRecord, that.serializedJournalRecord);
    }

    @Override
    public int hashCode() {
        int result = (int)(this.term ^ this.term >>> 32);
        result = 31 * result + (int)(this.index ^ this.index >>> 32);
        result = 31 * result + (int)(this.checksum ^ this.checksum >>> 32);
        result = 31 * result + Arrays.hashCode(this.serializedJournalRecord);
        return result;
    }

    @Override
    public String toString() {
        String recordToString = this.serializedJournalRecord != null ? "{rawToString=" + String.valueOf(this.serializedJournalRecord) + ", length=" + this.serializedJournalRecord.length + ", hashCode=" + Arrays.hashCode(this.serializedJournalRecord) + "}" : "null";
        return "ReplicatableJournalRecord{term=" + this.term + ", index=" + this.index + ", checksum=" + this.checksum + ", serializedJournalRecord=" + recordToString + "}";
    }

    public int approximateSize() {
        return this.serializedJournalRecord.length + 24;
    }
}

