/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.protocol;

import io.atomix.cluster.MemberId;
import io.atomix.raft.cluster.RaftMember;
import io.atomix.raft.protocol.AbstractRaftRequest;
import java.util.Objects;

public final class LeaveRequest
extends AbstractRaftRequest {
    private final RaftMember leaving;

    public LeaveRequest(RaftMember leaving) {
        this.leaving = Objects.requireNonNull(leaving);
    }

    public RaftMember leavingMember() {
        return this.leaving;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int hashCode() {
        return Objects.hash(this.leaving);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LeaveRequest that = (LeaveRequest)o;
        return Objects.equals(this.leaving, that.leaving);
    }

    @Override
    public MemberId from() {
        return this.leaving.memberId();
    }

    public static final class Builder
    extends AbstractRaftRequest.Builder<Builder, LeaveRequest> {
        private RaftMember leaving;

        private Builder() {
        }

        public Builder withLeavingMember(RaftMember leaving) {
            this.leaving = leaving;
            return this;
        }

        public LeaveRequest build() {
            this.validate();
            return new LeaveRequest(this.leaving);
        }

        @Override
        protected void validate() {
            Objects.requireNonNull(this.leaving, "leaving member cannot be null");
        }
    }
}

