/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.protocol;

import com.google.common.base.Preconditions;
import io.atomix.cluster.MemberId;
import io.atomix.raft.cluster.RaftMember;
import io.atomix.raft.protocol.AbstractRaftRequest;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

public class ForceConfigureRequest
extends AbstractRaftRequest {
    private final long term;
    private final long index;
    private final long timestamp;
    private final Set<RaftMember> members;
    private final String from;

    public ForceConfigureRequest(long term, long index, long timestamp, Set<RaftMember> newMembers, String from) {
        this.term = term;
        this.index = index;
        this.timestamp = timestamp;
        this.members = newMembers;
        this.from = from;
    }

    public int hashCode() {
        return Objects.hash(this.term, this.index, this.timestamp, this.members, this.from);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForceConfigureRequest that = (ForceConfigureRequest)o;
        return this.term == that.term && this.index == that.index && this.timestamp == that.timestamp && Objects.equals(this.members, that.members) && Objects.equals(this.from, that.from);
    }

    public String toString() {
        return "ForceConfigureRequest{term=" + this.term + ", index=" + this.index + ", timestamp=" + this.timestamp + ", members=" + String.valueOf(this.members) + ", from='" + this.from + "'}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public long term() {
        return this.term;
    }

    public long index() {
        return this.index;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public Collection<RaftMember> newMembers() {
        return this.members;
    }

    @Override
    public MemberId from() {
        return MemberId.from(this.from);
    }

    public static class Builder
    extends AbstractRaftRequest.Builder<Builder, ForceConfigureRequest> {
        private long term;
        private long index;
        private long timestamp;
        private Set<RaftMember> newMembers;
        private String from;

        public Builder withTerm(long term) {
            Preconditions.checkArgument((term > 0L ? 1 : 0) != 0, (Object)"term must be positive");
            this.term = term;
            return this;
        }

        public Builder withIndex(long index) {
            Preconditions.checkArgument((index >= 0L ? 1 : 0) != 0, (Object)"index must be positive");
            this.index = index;
            return this;
        }

        public Builder withTime(long timestamp) {
            Preconditions.checkArgument((timestamp > 0L ? 1 : 0) != 0, (Object)"timestamp must be positive");
            this.timestamp = timestamp;
            return this;
        }

        public Builder withNewMembers(Set<RaftMember> newMembers) {
            this.newMembers = (Set)Preconditions.checkNotNull(newMembers, (Object)"members cannot be null");
            return this;
        }

        public Builder from(MemberId from) {
            this.from = (String)((Object)from.id());
            return this;
        }

        public ForceConfigureRequest build() {
            this.validate();
            return new ForceConfigureRequest(this.term, this.index, this.timestamp, this.newMembers, this.from);
        }

        @Override
        protected void validate() {
            super.validate();
            Preconditions.checkArgument((this.term > 0L ? 1 : 0) != 0, (Object)"term must be positive");
            Preconditions.checkArgument((this.index >= 0L ? 1 : 0) != 0, (Object)"index must be positive");
            Preconditions.checkArgument((this.timestamp > 0L ? 1 : 0) != 0, (Object)"timestamp must be positive");
            Preconditions.checkNotNull(this.newMembers, (Object)"newMembers cannot be null");
            Preconditions.checkNotNull((Object)this.from, (Object)"sender id cannot be null");
        }
    }
}

