/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.protocol;

import com.google.common.base.Preconditions;
import io.atomix.cluster.MemberId;
import io.atomix.raft.cluster.RaftMember;
import io.atomix.raft.protocol.AbstractRaftRequest;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ConfigureRequest
extends AbstractRaftRequest {
    private final long term;
    private final String leader;
    private final long index;
    private final long timestamp;
    private final Collection<RaftMember> members;
    private final Collection<RaftMember> oldMembers;

    public ConfigureRequest(long term, String leader, long index, long timestamp, Collection<RaftMember> newMembers, Collection<RaftMember> oldMembers) {
        this.term = term;
        this.leader = leader;
        this.index = index;
        this.timestamp = timestamp;
        this.members = newMembers;
        this.oldMembers = oldMembers;
    }

    public int hashCode() {
        return Objects.hash(this.term, this.leader, this.index, this.timestamp, this.members, this.oldMembers);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigureRequest that = (ConfigureRequest)o;
        return this.term == that.term && this.index == that.index && this.timestamp == that.timestamp && Objects.equals(this.leader, that.leader) && Objects.equals(this.members, that.members) && Objects.equals(this.oldMembers, that.oldMembers);
    }

    public String toString() {
        return "ConfigureRequest{term=" + this.term + ", leader='" + this.leader + "', index=" + this.index + ", timestamp=" + this.timestamp + ", newMembers=" + String.valueOf(this.members) + ", oldMembers=" + String.valueOf(this.oldMembers) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public long term() {
        return this.term;
    }

    public MemberId leader() {
        return MemberId.from(this.leader);
    }

    public long index() {
        return this.index;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public Collection<RaftMember> newMembers() {
        return this.members;
    }

    public Collection<RaftMember> oldMembers() {
        return this.oldMembers;
    }

    @Override
    public MemberId from() {
        return this.leader();
    }

    public static class Builder
    extends AbstractRaftRequest.Builder<Builder, ConfigureRequest> {
        private long term;
        private String leader;
        private long index;
        private long timestamp;
        private Collection<RaftMember> newMembers;
        private Collection<RaftMember> oldMembers = List.of();

        public Builder withTerm(long term) {
            Preconditions.checkArgument((term > 0L ? 1 : 0) != 0, (Object)"term must be positive");
            this.term = term;
            return this;
        }

        public Builder withLeader(MemberId leader) {
            this.leader = (String)((Object)((MemberId)Preconditions.checkNotNull((Object)leader, (Object)"leader cannot be null")).id());
            return this;
        }

        public Builder withIndex(long index) {
            Preconditions.checkArgument((index >= 0L ? 1 : 0) != 0, (Object)"index must be positive");
            this.index = index;
            return this;
        }

        public Builder withTime(long timestamp) {
            Preconditions.checkArgument((timestamp > 0L ? 1 : 0) != 0, (Object)"timestamp must be positive");
            this.timestamp = timestamp;
            return this;
        }

        public Builder withNewMembers(Collection<RaftMember> newMembers) {
            this.newMembers = (Collection)Preconditions.checkNotNull(newMembers, (Object)"members cannot be null");
            return this;
        }

        public Builder withOldMembers(Collection<RaftMember> oldMembers) {
            this.oldMembers = (Collection)Preconditions.checkNotNull(oldMembers, (Object)"members cannot be null");
            return this;
        }

        public ConfigureRequest build() {
            this.validate();
            return new ConfigureRequest(this.term, this.leader, this.index, this.timestamp, this.newMembers, this.oldMembers);
        }

        @Override
        protected void validate() {
            super.validate();
            Preconditions.checkArgument((this.term > 0L ? 1 : 0) != 0, (Object)"term must be positive");
            Preconditions.checkNotNull((Object)this.leader, (Object)"leader cannot be null");
            Preconditions.checkArgument((this.index >= 0L ? 1 : 0) != 0, (Object)"index must be positive");
            Preconditions.checkArgument((this.timestamp > 0L ? 1 : 0) != 0, (Object)"timestamp must be positive");
            Preconditions.checkNotNull(this.newMembers, (Object)"newMembers cannot be null");
            Preconditions.checkNotNull(this.oldMembers, (Object)"oldMembers cannot be null");
        }
    }
}

