/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.protocol;

import com.google.common.base.MoreObjects;
import io.atomix.cluster.MemberId;
import io.atomix.raft.protocol.AbstractRaftRequest;
import io.atomix.raft.protocol.PersistedRaftRecord;
import java.util.List;
import java.util.Objects;

public class AppendRequest
extends AbstractRaftRequest {
    private final long term;
    private final String leader;
    private final long prevLogIndex;
    private final long prevLogTerm;
    private final List<PersistedRaftRecord> entries;
    private final long commitIndex;

    public AppendRequest(long term, String leader, long prevLogIndex, long prevLogTerm, List<PersistedRaftRecord> entries, long commitIndex) {
        this.term = term;
        this.leader = leader;
        this.prevLogIndex = prevLogIndex;
        this.prevLogTerm = prevLogTerm;
        this.entries = entries;
        this.commitIndex = commitIndex;
    }

    public long term() {
        return this.term;
    }

    public MemberId leader() {
        return MemberId.from(this.leader);
    }

    public long prevLogIndex() {
        return this.prevLogIndex;
    }

    public long prevLogTerm() {
        return this.prevLogTerm;
    }

    public List<PersistedRaftRecord> entries() {
        return this.entries;
    }

    public long commitIndex() {
        return this.commitIndex;
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.term, this.leader, this.prevLogIndex, this.prevLogTerm, this.entries, this.commitIndex);
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            AppendRequest request = (AppendRequest)object;
            return request.term == this.term && request.leader.equals(this.leader) && request.prevLogIndex == this.prevLogIndex && request.prevLogTerm == this.prevLogTerm && request.entries.equals(this.entries) && request.commitIndex == this.commitIndex;
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("term", this.term).add("leader", (Object)this.leader).add("prevLogIndex", this.prevLogIndex).add("prevLogTerm", this.prevLogTerm).add("entries", this.entries.size()).add("commitIndex", this.commitIndex).toString();
    }

    @Override
    public MemberId from() {
        return this.leader();
    }
}

