/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.metrics;

import io.atomix.raft.metrics.RaftKeyNames;
import io.atomix.raft.metrics.RaftMetrics;
import io.atomix.raft.metrics.SnapshotReplicationMetricsDoc;
import io.camunda.zeebe.util.CloseableSilently;
import io.camunda.zeebe.util.micrometer.StatefulGauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;

public class SnapshotReplicationMetrics
extends RaftMetrics
implements CloseableSilently {
    private final MeterRegistry meterRegistry;
    private final StatefulGauge count;
    private final StatefulGauge duration;

    public SnapshotReplicationMetrics(String partitionName, MeterRegistry meterRegistry) {
        super(partitionName);
        this.meterRegistry = meterRegistry;
        this.count = StatefulGauge.builder((String)SnapshotReplicationMetricsDoc.COUNT.getName()).description(SnapshotReplicationMetricsDoc.COUNT.getDescription()).tag(RaftKeyNames.PARTITION_GROUP.asString(), this.partitionGroupName).register(meterRegistry);
        this.duration = StatefulGauge.builder((String)SnapshotReplicationMetricsDoc.DURATION.getName()).description(SnapshotReplicationMetricsDoc.DURATION.getDescription()).tag(RaftKeyNames.PARTITION_GROUP.asString(), this.partitionGroupName).register(meterRegistry);
    }

    public void incrementCount() {
        this.count.increment();
    }

    public void decrementCount() {
        this.count.decrement();
    }

    public void setCount(int value) {
        this.count.set((long)value);
    }

    public void observeDuration(long durationMillis) {
        this.duration.set(durationMillis);
    }

    public void close() {
        this.meterRegistry.remove((Meter)this.count);
        this.meterRegistry.remove((Meter)this.duration);
    }
}

