/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.metrics;

import io.atomix.raft.metrics.RaftKeyNames;
import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Meter;

public enum LeaderMetricsDoc implements ExtendedMeterDocumentation
{
    APPEND_ENTRIES_LATENCY{

        public String getBaseUnit() {
            return "ms";
        }

        public String getName() {
            return "atomix.append.entries.latency";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public String getDescription() {
            return "Latency to append an entry to a follower";
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{MicrometerUtil.PartitionKeyNames.PARTITION, RaftKeyNames.FOLLOWER, RaftKeyNames.PARTITION_GROUP};
        }
    }
    ,
    APPEND_RATE{

        public String getName() {
            return "atomix.append.entries.rate";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public String getDescription() {
            return "The count of entries appended (counting entries, not their size)";
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{MicrometerUtil.PartitionKeyNames.PARTITION, RaftKeyNames.FOLLOWER, RaftKeyNames.PARTITION_GROUP};
        }
    }
    ,
    APPEND_DATA_RATE{

        public String getName() {
            return "atomix.append.entries.data.rate";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public String getDescription() {
            return "The count of entries appended (counting entries, not their size)";
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{MicrometerUtil.PartitionKeyNames.PARTITION, RaftKeyNames.FOLLOWER, RaftKeyNames.PARTITION_GROUP};
        }
    }
    ,
    NON_REPLICATED_ENTRIES{

        public String getName() {
            return "atomix.non_replicated.entries";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public String getDescription() {
            return "The number of non-replicated entries for a given followers";
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{MicrometerUtil.PartitionKeyNames.PARTITION, RaftKeyNames.FOLLOWER, RaftKeyNames.PARTITION_GROUP};
        }
    }
    ,
    COMMIT_RATE{

        public String getName() {
            return "atomix.commit.entries.rate";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public String getDescription() {
            return "The count of entries committed (counting entries, not their size)";
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{RaftKeyNames.PARTITION_GROUP, MicrometerUtil.PartitionKeyNames.PARTITION};
        }
    }
    ,
    NON_COMMITTED_ENTRIES{

        public String getName() {
            return "atomix.non_committed.entries";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public String getDescription() {
            return "The number of non-committed entries on the leader";
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{RaftKeyNames.PARTITION_GROUP, MicrometerUtil.PartitionKeyNames.PARTITION};
        }
    };

}

