/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.impl;

import com.google.common.base.Preconditions;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.MemberId;
import io.atomix.raft.ElectionTimer;
import io.atomix.raft.RaftApplicationEntryCommittedPositionListener;
import io.atomix.raft.RaftCommitListener;
import io.atomix.raft.RaftError;
import io.atomix.raft.RaftRoleChangeListener;
import io.atomix.raft.RaftServer;
import io.atomix.raft.RaftThreadContextFactory;
import io.atomix.raft.SnapshotReplicationListener;
import io.atomix.raft.cluster.RaftMember;
import io.atomix.raft.cluster.impl.DefaultRaftMember;
import io.atomix.raft.cluster.impl.RaftClusterContext;
import io.atomix.raft.impl.LogCompactor;
import io.atomix.raft.impl.PriorityElectionTimer;
import io.atomix.raft.impl.RandomizedElectionTimer;
import io.atomix.raft.metrics.RaftReplicationMetrics;
import io.atomix.raft.metrics.RaftRoleMetrics;
import io.atomix.raft.metrics.RaftServiceMetrics;
import io.atomix.raft.partition.RaftElectionConfig;
import io.atomix.raft.partition.RaftPartitionConfig;
import io.atomix.raft.protocol.AppendResponse;
import io.atomix.raft.protocol.ConfigureRequest;
import io.atomix.raft.protocol.ConfigureResponse;
import io.atomix.raft.protocol.ForceConfigureRequest;
import io.atomix.raft.protocol.ForceConfigureResponse;
import io.atomix.raft.protocol.InstallRequest;
import io.atomix.raft.protocol.InstallResponse;
import io.atomix.raft.protocol.JoinRequest;
import io.atomix.raft.protocol.JoinResponse;
import io.atomix.raft.protocol.LeaveRequest;
import io.atomix.raft.protocol.LeaveResponse;
import io.atomix.raft.protocol.PollRequest;
import io.atomix.raft.protocol.PollResponse;
import io.atomix.raft.protocol.ProtocolVersionHandler;
import io.atomix.raft.protocol.RaftRequest;
import io.atomix.raft.protocol.RaftResponse;
import io.atomix.raft.protocol.RaftServerProtocol;
import io.atomix.raft.protocol.ReconfigureRequest;
import io.atomix.raft.protocol.ReconfigureResponse;
import io.atomix.raft.protocol.TransferRequest;
import io.atomix.raft.protocol.TransferResponse;
import io.atomix.raft.protocol.VoteRequest;
import io.atomix.raft.protocol.VoteResponse;
import io.atomix.raft.roles.ActiveRole;
import io.atomix.raft.roles.CandidateRole;
import io.atomix.raft.roles.FollowerRole;
import io.atomix.raft.roles.InactiveRole;
import io.atomix.raft.roles.LeaderRole;
import io.atomix.raft.roles.PassiveRole;
import io.atomix.raft.roles.PromotableRole;
import io.atomix.raft.roles.RaftRole;
import io.atomix.raft.storage.RaftStorage;
import io.atomix.raft.storage.StorageException;
import io.atomix.raft.storage.log.RaftLog;
import io.atomix.raft.storage.system.Configuration;
import io.atomix.raft.storage.system.MetaStore;
import io.atomix.raft.utils.StateUtil;
import io.atomix.raft.zeebe.EntryValidator;
import io.atomix.utils.concurrent.ThreadContext;
import io.atomix.utils.concurrent.Threads;
import io.camunda.zeebe.snapshots.PersistedSnapshot;
import io.camunda.zeebe.snapshots.PersistedSnapshotStore;
import io.camunda.zeebe.snapshots.ReceivableSnapshotStore;
import io.camunda.zeebe.util.exception.UnrecoverableException;
import io.camunda.zeebe.util.health.FailureListener;
import io.camunda.zeebe.util.health.HealthMonitorable;
import io.camunda.zeebe.util.health.HealthReport;
import io.camunda.zeebe.util.logging.ThrottledLogger;
import io.micrometer.core.instrument.MeterRegistry;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class RaftContext
implements AutoCloseable,
HealthMonitorable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RaftContext.class);
    private static final long NO_CONFIGURATION_INDEX = -1L;
    private static final String RAFT_ROLE_KEY = "raft-role";
    protected final String name;
    protected final ThreadContext threadContext;
    protected final ClusterMembershipService membershipService;
    protected final RaftClusterContext cluster;
    protected final RaftServerProtocol protocol;
    protected final RaftStorage storage;
    private final RaftElectionConfig electionConfig;
    private final Set<RaftRoleChangeListener> roleChangeListeners = new CopyOnWriteArraySet<RaftRoleChangeListener>();
    private final Set<Consumer<State>> stateChangeListeners = new CopyOnWriteArraySet<Consumer<State>>();
    private final Set<Consumer<RaftMember>> electionListeners = new CopyOnWriteArraySet<Consumer<RaftMember>>();
    private final Set<RaftCommitListener> commitListeners = new CopyOnWriteArraySet<RaftCommitListener>();
    private final Set<RaftApplicationEntryCommittedPositionListener> committedEntryListeners = new CopyOnWriteArraySet<RaftApplicationEntryCommittedPositionListener>();
    private final Set<SnapshotReplicationListener> snapshotReplicationListeners = new CopyOnWriteArraySet<SnapshotReplicationListener>();
    private final Set<FailureListener> failureListeners = new CopyOnWriteArraySet<FailureListener>();
    private final RaftRoleMetrics raftRoleMetrics;
    private final RaftReplicationMetrics replicationMetrics;
    private final MetaStore meta;
    private final RaftLog raftLog;
    private final ReceivableSnapshotStore persistedSnapshotStore;
    private final LogCompactor logCompactor;
    private volatile State state = State.ACTIVE;
    private final Object externalAccessLock = new Object();
    private RaftRole role = new InactiveRole(this);
    private volatile MemberId leader;
    private volatile long term;
    private MemberId lastVotedFor;
    private long commitIndex;
    private long firstCommitIndex;
    private volatile boolean started;
    private EntryValidator entryValidator;
    private final Random random;
    private PersistedSnapshot currentSnapshot;
    private final int snapshotChunkSize;
    private boolean ongoingTransition = false;
    private MissedSnapshotReplicationEvents missedSnapshotReplicationEvents = MissedSnapshotReplicationEvents.NONE;
    private volatile HealthReport health;
    private long lastHeartbeat;
    private final RaftPartitionConfig partitionConfig;
    private final int partitionId;
    private final MeterRegistry meterRegistry;

    public RaftContext(String name, int partitionId, MemberId localMemberId, ClusterMembershipService membershipService, RaftServerProtocol protocol, RaftStorage storage, RaftThreadContextFactory threadContextFactory, Supplier<Random> randomFactory, RaftElectionConfig electionConfig, RaftPartitionConfig partitionConfig, MeterRegistry meterRegistry) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        this.membershipService = (ClusterMembershipService)Preconditions.checkNotNull((Object)membershipService, (Object)"membershipService cannot be null");
        this.protocol = (RaftServerProtocol)Preconditions.checkNotNull((Object)protocol, (Object)"protocol cannot be null");
        this.storage = (RaftStorage)Preconditions.checkNotNull((Object)storage, (Object)"storage cannot be null");
        this.random = randomFactory.get();
        this.partitionId = partitionId;
        this.meterRegistry = (MeterRegistry)Preconditions.checkNotNull((Object)meterRegistry, (Object)"meterRegistry cannot be null");
        this.health = HealthReport.healthy((HealthMonitorable)this);
        this.raftRoleMetrics = new RaftRoleMetrics(name, meterRegistry);
        this.electionConfig = electionConfig;
        if (electionConfig.isPriorityElectionEnabled()) {
            LOGGER.debug("Priority election is enabled with target priority {} and node priority {}", (Object)electionConfig.getInitialTargetPriority(), (Object)electionConfig.getNodePriority());
        }
        if (!storage.lock((String)((Object)localMemberId.id()))) {
            throw new StorageException("Failed to acquire storage lock; ensure each Raft server is configured with a distinct storage directory");
        }
        this.threadContext = this.createThreadContext("raft-server", partitionId, threadContextFactory, (String)((Object)localMemberId.id()));
        this.meta = storage.openMetaStore();
        this.term = this.meta.loadTerm();
        this.lastVotedFor = this.meta.loadVote();
        this.raftLog = storage.openLog(this.meta, () -> this.createThreadContext("raft-log", partitionId, threadContextFactory, (String)((Object)localMemberId.id())));
        this.persistedSnapshotStore = storage.getPersistedSnapshotStore();
        this.persistedSnapshotStore.addSnapshotListener(this::onNewPersistedSnapshot);
        this.persistedSnapshotStore.getLatestSnapshot().ifPresent(persistedSnapshot -> {
            this.currentSnapshot = persistedSnapshot;
        });
        StateUtil.verifySnapshotLogConsistent(partitionId, this.getCurrentSnapshotIndex(), this.raftLog.getFirstIndex(), this.raftLog.isEmpty(), this.raftLog::reset, LOGGER);
        this.logCompactor = new LogCompactor(this.threadContext, this.raftLog, partitionConfig.getPreferSnapshotReplicationThreshold(), new RaftServiceMetrics(name, meterRegistry));
        this.snapshotChunkSize = partitionConfig.getSnapshotChunkSize();
        this.partitionConfig = partitionConfig;
        this.cluster = new RaftClusterContext(localMemberId, this);
        this.replicationMetrics = new RaftReplicationMetrics(name, meterRegistry);
        this.replicationMetrics.setAppendIndex(this.raftLog.getLastIndex());
        this.lastHeartbeat = System.currentTimeMillis();
        this.registerHandlers(protocol);
        this.started = true;
        this.addCommitListener(new AwaitingReadyCommitListener());
        if (!this.raftLog.isEmpty() && this.term == 0L) {
            this.setTerm(this.raftLog.getLastEntry().term());
        }
    }

    private ThreadContext createThreadContext(String name, int partitionId, RaftThreadContextFactory threadContextFactory, String localMemberId) {
        ThreadContext context = threadContextFactory.createContext(Threads.namedThreads((String)"%s-%s-%d".formatted(name, localMemberId, partitionId), (Logger)LOGGER), this::onUncaughtException);
        context.execute(() -> {
            MDC.put((String)"partitionId", (String)String.valueOf(partitionId));
            MDC.put((String)"actor-name", (String)(name + "-" + partitionId));
            MDC.put((String)"actor-scheduler", (String)("Broker-" + localMemberId));
            MDC.put((String)RAFT_ROLE_KEY, (String)RaftServer.Role.INACTIVE.name());
        });
        return context;
    }

    private void onNewPersistedSnapshot(PersistedSnapshot persistedSnapshot) {
        this.threadContext.execute(this::updateCurrentSnapshot);
    }

    private void onUncaughtException(Throwable error) {
        LOGGER.error("An uncaught exception occurred, transition to inactive role", error);
        try {
            this.transition(RaftServer.Role.INACTIVE);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred when transitioning to inactive, closing the raft context", (Throwable)e);
            this.close();
        }
        this.notifyFailureListeners(error);
    }

    private void notifyFailureListeners(Throwable error) {
        try {
            if (error instanceof UnrecoverableException) {
                this.health = HealthReport.dead((HealthMonitorable)this).withIssue(error, Instant.now());
                this.failureListeners.forEach(l -> l.onUnrecoverableFailure(this.health));
            } else {
                this.health = HealthReport.unhealthy((HealthMonitorable)this).withIssue(error, Instant.now());
                this.failureListeners.forEach(l -> l.onFailure(this.health));
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not notify failure listeners", (Throwable)e);
        }
    }

    private void registerHandlers(RaftServerProtocol protocol) {
        protocol.registerConfigureHandler(request -> this.handleRequestOnContext((RaftRequest)request, () -> this.role.onConfigure((ConfigureRequest)request), ConfigureResponse::builder));
        protocol.registerInstallHandler(request -> this.handleRequestOnContext((RaftRequest)request, () -> this.role.onInstall((InstallRequest)request), InstallResponse::builder));
        protocol.registerReconfigureHandler(request -> this.handleRequestOnContext((RaftRequest)request, () -> this.role.onReconfigure((ReconfigureRequest)request), ReconfigureResponse::builder));
        protocol.registerForceConfigureHandler(request -> this.handleRequestOnContext((RaftRequest)request, () -> this.role.onForceConfigure((ForceConfigureRequest)request), ForceConfigureResponse::builder));
        protocol.registerJoinHandler(request -> this.handleRequestOnContext((RaftRequest)request, () -> this.role.onJoin((JoinRequest)request), JoinResponse::builder));
        protocol.registerLeaveHandler(request -> this.handleRequestOnContext((RaftRequest)request, () -> this.role.onLeave((LeaveRequest)request), LeaveResponse::builder));
        protocol.registerTransferHandler(request -> this.handleRequestOnContext((RaftRequest)request, () -> this.role.onTransfer((TransferRequest)request), TransferResponse::builder));
        protocol.registerAppendV1Handler(request -> this.handleRequestOnContext((RaftRequest)request, () -> this.role.onAppend(ProtocolVersionHandler.transform(request)), AppendResponse::builder));
        protocol.registerAppendV2Handler(request -> this.handleRequestOnContext((RaftRequest)request, () -> this.role.onAppend(ProtocolVersionHandler.transform(request)), AppendResponse::builder));
        protocol.registerPollHandler(request -> this.handleRequestOnContext((RaftRequest)request, () -> this.role.onPoll((PollRequest)request), PollResponse::builder));
        protocol.registerVoteHandler(request -> this.handleRequestOnContext((RaftRequest)request, () -> this.role.onVote((VoteRequest)request), VoteResponse::builder));
    }

    private <T extends RaftResponse.Builder<T, R>, R extends RaftResponse> CompletableFuture<R> handleRequestOnContext(RaftRequest request, Supplier<CompletableFuture<R>> function, Supplier<RaftResponse.Builder<T, R>> responseBuilder) {
        CompletableFuture future = new CompletableFuture();
        this.threadContext.execute(() -> this.role.shouldAcceptRequest(request).ifRightOrLeft(arg_0 -> RaftContext.lambda$handleRequestOnContext$28((Supplier)function, future, arg_0), arg_0 -> RaftContext.lambda$handleRequestOnContext$29((Supplier)responseBuilder, future, arg_0)));
        return future;
    }

    public int getMaxAppendBatchSize() {
        return this.partitionConfig.getMaxAppendBatchSize();
    }

    public int getMaxAppendsPerFollower() {
        return this.partitionConfig.getMaxAppendsPerFollower();
    }

    public void addRoleChangeListener(RaftRoleChangeListener listener) {
        this.threadContext.execute(() -> {
            this.roleChangeListeners.add(listener);
            if (!this.ongoingTransition) {
                listener.onNewRole(this.getRole(), this.getTerm());
            }
        });
    }

    public void removeRoleChangeListener(RaftRoleChangeListener listener) {
        this.roleChangeListeners.remove(listener);
    }

    public void addStateChangeListener(Consumer<State> listener) {
        listener.accept(this.state);
        this.stateChangeListeners.add(listener);
    }

    public void removeStateChangeListener(Consumer<State> listener) {
        this.stateChangeListeners.remove(listener);
    }

    public void addCommitListener(RaftCommitListener commitListener) {
        this.commitListeners.add(commitListener);
    }

    public void removeCommitListener(RaftCommitListener commitListener) {
        this.commitListeners.remove(commitListener);
    }

    public void addCommittedEntryListener(RaftApplicationEntryCommittedPositionListener raftApplicationEntryCommittedPositionListener) {
        this.committedEntryListeners.add(raftApplicationEntryCommittedPositionListener);
    }

    public void removeCommittedEntryListener(RaftApplicationEntryCommittedPositionListener raftApplicationEntryCommittedPositionListener) {
        this.committedEntryListeners.remove(raftApplicationEntryCommittedPositionListener);
    }

    public void notifyCommitListeners(long lastCommitIndex) {
        this.commitListeners.forEach(listener -> listener.onCommit(lastCommitIndex));
    }

    public void notifyApplicationEntryCommittedPositionListeners(long committedEntry) {
        this.committedEntryListeners.forEach(listener -> listener.onCommit(committedEntry));
    }

    public long setCommitIndex(long commitIndex) {
        Preconditions.checkArgument((commitIndex >= 0L ? 1 : 0) != 0, (Object)"commitIndex must be positive");
        commitIndex = Math.min(commitIndex, this.raftLog.getLastIndex());
        long previousCommitIndex = this.commitIndex;
        if (commitIndex > previousCommitIndex) {
            long configurationIndex;
            if (this.isLeader()) {
                this.raftLog.flush();
            }
            this.raftLog.setCommitIndex(commitIndex);
            this.commitIndex = commitIndex;
            Configuration clusterConfig = this.cluster.getConfiguration();
            if (clusterConfig != null && (configurationIndex = clusterConfig.index()) > previousCommitIndex && configurationIndex <= commitIndex) {
                this.cluster.commitCurrentConfiguration();
            }
            this.replicationMetrics.setCommitIndex(commitIndex);
            this.notifyCommitListeners(commitIndex);
        }
        return previousCommitIndex;
    }

    public void addSnapshotReplicationListener(SnapshotReplicationListener snapshotReplicationListener) {
        this.threadContext.execute(() -> {
            this.snapshotReplicationListeners.add(snapshotReplicationListener);
            if (this.role.role() == RaftServer.Role.FOLLOWER) {
                switch (this.missedSnapshotReplicationEvents.ordinal()) {
                    case 1: {
                        snapshotReplicationListener.onSnapshotReplicationStarted();
                        break;
                    }
                    case 2: {
                        snapshotReplicationListener.onSnapshotReplicationStarted();
                        snapshotReplicationListener.onSnapshotReplicationCompleted(this.term);
                        break;
                    }
                }
            }
        });
    }

    public void removeSnapshotReplicationListener(SnapshotReplicationListener snapshotReplicationListener) {
        this.threadContext.execute(() -> this.snapshotReplicationListeners.remove(snapshotReplicationListener));
    }

    public void notifySnapshotReplicationStarted() {
        this.threadContext.execute(() -> {
            this.missedSnapshotReplicationEvents = MissedSnapshotReplicationEvents.STARTED;
            this.snapshotReplicationListeners.forEach(SnapshotReplicationListener::onSnapshotReplicationStarted);
        });
    }

    public void notifySnapshotReplicationCompleted() {
        this.threadContext.execute(() -> {
            this.snapshotReplicationListeners.forEach(l -> l.onSnapshotReplicationCompleted(this.term));
            this.missedSnapshotReplicationEvents = MissedSnapshotReplicationEvents.COMPLETED;
        });
    }

    public CompletableFuture<Void> flushLog() {
        if (this.raftLog.flushesDirectly()) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.runAsync(this.raftLog::forceFlush, (Executor)this.threadContext);
    }

    public void addLeaderElectionListener(Consumer<RaftMember> listener) {
        this.electionListeners.add(listener);
    }

    public void removeLeaderElectionListener(Consumer<RaftMember> listener) {
        this.electionListeners.remove(listener);
    }

    public RaftClusterContext getCluster() {
        return this.cluster;
    }

    public DefaultRaftMember getLeader() {
        MemberId leader = this.leader;
        return leader != null ? this.cluster.getMember(leader) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transition(RaftServer.Role role) {
        this.checkThread();
        Preconditions.checkNotNull((Object)((Object)role));
        if (this.role.role() == role) {
            return;
        }
        LOGGER.info("Transitioning to {}", (Object)role);
        this.startTransition();
        try {
            this.role.stop().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException("failed to close Raft state", e);
        }
        MDC.put((String)RAFT_ROLE_KEY, (String)role.name());
        try {
            RaftRole newRole = this.createRole(role);
            Object object = this.externalAccessLock;
            synchronized (object) {
                this.role = newRole;
            }
            this.role.start().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException("failed to initialize Raft state", e);
        }
        if (!this.role.role().active() && role.active()) {
            this.health = HealthReport.healthy((HealthMonitorable)this);
            this.failureListeners.forEach(l -> l.onRecovered(this.health));
        }
        if (this.role.role() == role) {
            if (this.role.role() == RaftServer.Role.LEADER) {
                LeaderRole leaderRole = (LeaderRole)this.role;
                leaderRole.onInitialEntriesCommitted(() -> {
                    if (this.role == leaderRole) {
                        this.notifyRoleChangeListeners();
                        this.completeTransition();
                    }
                });
            } else {
                this.notifyRoleChangeListeners();
                this.completeTransition();
            }
        }
    }

    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    private void startTransition() {
        this.ongoingTransition = true;
    }

    private void completeTransition() {
        this.missedSnapshotReplicationEvents = MissedSnapshotReplicationEvents.NONE;
        this.ongoingTransition = false;
    }

    private void notifyRoleChangeListeners() {
        try {
            this.roleChangeListeners.forEach(l -> l.onNewRole(this.role.role(), this.getTerm()));
        }
        catch (Exception exception) {
            LOGGER.error("Unexpected error on calling role change listeners.", (Throwable)exception);
        }
    }

    public void checkThread() {
        this.threadContext.checkThread();
    }

    private RaftRole createRole(RaftServer.Role role) {
        switch (role) {
            case INACTIVE: {
                this.raftRoleMetrics.becomingInactive();
                return new InactiveRole(this);
            }
            case PASSIVE: {
                return new PassiveRole(this);
            }
            case PROMOTABLE: {
                return new PromotableRole(this);
            }
            case FOLLOWER: {
                this.raftRoleMetrics.becomingFollower();
                return new FollowerRole(this, this::createElectionTimer);
            }
            case CANDIDATE: {
                this.raftRoleMetrics.becomingCandidate();
                return new CandidateRole(this);
            }
            case LEADER: {
                this.raftRoleMetrics.becomingLeader();
                return new LeaderRole(this);
            }
        }
        throw new AssertionError();
    }

    private ElectionTimer createElectionTimer(Runnable triggerElection, Logger log) {
        if (this.electionConfig.isPriorityElectionEnabled()) {
            return new PriorityElectionTimer(this.partitionConfig.getElectionTimeout(), this.threadContext, triggerElection, log, this.electionConfig.getInitialTargetPriority(), this.electionConfig.getNodePriority());
        }
        return new RandomizedElectionTimer(this.partitionConfig.getElectionTimeout(), this.threadContext, this.random, triggerElection, log);
    }

    public void transition(RaftMember.Type type) {
        switch (type) {
            case ACTIVE: {
                if (this.role instanceof ActiveRole) break;
                this.transition(RaftServer.Role.FOLLOWER);
                break;
            }
            case PROMOTABLE: {
                if (this.role.role() == RaftServer.Role.PROMOTABLE) break;
                this.transition(RaftServer.Role.PROMOTABLE);
                break;
            }
            case PASSIVE: {
                if (this.role.role() == RaftServer.Role.PASSIVE) break;
                this.transition(RaftServer.Role.PASSIVE);
                break;
            }
            default: {
                if (this.role.role() == RaftServer.Role.INACTIVE) break;
                this.transition(RaftServer.Role.INACTIVE);
            }
        }
    }

    @Override
    public void close() {
        this.raftRoleMetrics.becomingInactive();
        this.started = false;
        this.unregisterHandlers(this.protocol);
        try {
            this.raftLog.close();
        }
        catch (Exception e) {
            LOGGER.error("Failed to close raft log", (Throwable)e);
        }
        try {
            this.meta.close();
        }
        catch (Exception e) {
            LOGGER.error("Failed to close metastore", (Throwable)e);
        }
        this.threadContext.close();
    }

    private void unregisterHandlers(RaftServerProtocol protocol) {
        protocol.unregisterConfigureHandler();
        protocol.unregisterInstallHandler();
        protocol.unregisterReconfigureHandler();
        protocol.unregisterForceConfigureHandler();
        protocol.unregisterJoinHandler();
        protocol.unregisterLeaveHandler();
        protocol.unregisterTransferHandler();
        protocol.unregisterAppendHandler();
        protocol.unregisterPollHandler();
        protocol.unregisterVoteHandler();
    }

    public String toString() {
        return this.getClass().getCanonicalName();
    }

    public long getCommitIndex() {
        return this.commitIndex;
    }

    public Duration getElectionTimeout() {
        return this.partitionConfig.getElectionTimeout();
    }

    public long getFirstCommitIndex() {
        return this.firstCommitIndex;
    }

    public void setFirstCommitIndex(long firstCommitIndex) {
        if (this.firstCommitIndex == 0L) {
            if (firstCommitIndex == 0L) {
                return;
            }
            this.firstCommitIndex = firstCommitIndex;
            LOGGER.info("Setting firstCommitIndex to {}. RaftServer is ready only after it has committed events up to this index", (Object)firstCommitIndex);
        }
    }

    public Duration getHeartbeatInterval() {
        return this.partitionConfig.getHeartbeatInterval();
    }

    public EntryValidator getEntryValidator() {
        return this.entryValidator;
    }

    public void setEntryValidator(EntryValidator validator) {
        this.entryValidator = validator;
    }

    public MemberId getLastVotedFor() {
        return this.lastVotedFor;
    }

    public void setLastVotedFor(MemberId candidate) {
        Preconditions.checkState((this.lastVotedFor == null || candidate == null ? 1 : 0) != 0, (Object)"Already voted for another candidate");
        this.lastVotedFor = candidate;
        this.meta.storeVote(this.lastVotedFor);
        if (candidate != null) {
            LOGGER.debug("Voted for {}", (Object)candidate);
        } else {
            LOGGER.trace("Reset last voted for");
        }
    }

    public RaftLog getLog() {
        return this.raftLog;
    }

    public ClusterMembershipService getMembershipService() {
        return this.membershipService;
    }

    public MetaStore getMetaStore() {
        return this.meta;
    }

    public String getName() {
        return this.name;
    }

    public String componentName() {
        return this.name;
    }

    public HealthReport getHealthReport() {
        return this.health;
    }

    public void addFailureListener(FailureListener listener) {
        this.failureListeners.add(listener);
    }

    public void removeFailureListener(FailureListener listener) {
        this.failureListeners.remove(listener);
    }

    public RaftServerProtocol getProtocol() {
        return this.protocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RaftRole getRaftRole() {
        Object object = this.externalAccessLock;
        synchronized (object) {
            return this.role;
        }
    }

    public RaftRoleMetrics getRaftRoleMetrics() {
        return this.raftRoleMetrics;
    }

    public RaftServer.Role getRole() {
        return this.getRaftRole().role();
    }

    public LogCompactor getLogCompactor() {
        return this.logCompactor;
    }

    public ReceivableSnapshotStore getPersistedSnapshotStore() {
        return this.persistedSnapshotStore;
    }

    public State getState() {
        return this.state;
    }

    public RaftStorage getStorage() {
        return this.storage;
    }

    public long getTerm() {
        return this.term;
    }

    public void setTerm(long term) {
        if (term > this.term) {
            this.term = term;
            this.leader = null;
            this.lastVotedFor = null;
            this.meta.storeTerm(this.term);
            this.meta.storeVote(this.lastVotedFor);
            LOGGER.debug("Set term {}", (Object)term);
        }
    }

    public ThreadContext getThreadContext() {
        return this.threadContext;
    }

    public boolean isLeader() {
        MemberId leader = this.leader;
        return leader != null && leader.equals(this.cluster.getLocalMember().memberId());
    }

    public void setLeader(MemberId leader) {
        if (!Objects.equals(this.leader, leader)) {
            if (leader == null) {
                this.leader = null;
            } else {
                DefaultRaftMember member = this.cluster.getMember(leader);
                if (member != null) {
                    this.leader = leader;
                    LOGGER.info("Found leader {}", (Object)member.memberId());
                    this.electionListeners.forEach(l -> l.accept(member));
                }
            }
            LOGGER.trace("Set leader {}", (Object)this.leader);
        }
    }

    public PersistedSnapshot getCurrentSnapshot() {
        return this.currentSnapshot;
    }

    public void updateCurrentSnapshot() {
        this.checkThread();
        this.currentSnapshot = this.persistedSnapshotStore.getLatestSnapshot().orElse(null);
        LOGGER.trace("Set currentSnapshot to {}", (Object)this.currentSnapshot);
        this.logCompactor.compactFromSnapshots((PersistedSnapshotStore)this.persistedSnapshotStore);
    }

    public long getCurrentSnapshotIndex() {
        return this.currentSnapshot != null ? this.currentSnapshot.getIndex() : 0L;
    }

    public long getCurrentConfigurationIndex() {
        Configuration configuration = this.cluster.getConfiguration();
        return configuration != null ? configuration.index() : -1L;
    }

    public boolean isRunning() {
        return this.started;
    }

    public RaftReplicationMetrics getReplicationMetrics() {
        return this.replicationMetrics;
    }

    public Random getRandom() {
        return this.random;
    }

    public long getLastHeartbeat() {
        return this.lastHeartbeat;
    }

    public void setLastHeartbeat(long lastHeartbeat) {
        this.lastHeartbeat = lastHeartbeat;
    }

    public void resetLastHeartbeat() {
        this.setLastHeartbeat(System.currentTimeMillis());
    }

    public int getMinStepDownFailureCount() {
        return this.partitionConfig.getMinStepDownFailureCount();
    }

    public Duration getMaxQuorumResponseTimeout() {
        return this.partitionConfig.getMaxQuorumResponseTimeout();
    }

    public int getPreferSnapshotReplicationThreshold() {
        return this.partitionConfig.getPreferSnapshotReplicationThreshold();
    }

    public void setPreferSnapshotReplicationThreshold(int snapshotReplicationThreshold) {
        this.partitionConfig.setPreferSnapshotReplicationThreshold(snapshotReplicationThreshold);
    }

    public CompletableFuture<Void> reconfigurePriority(int newPriority) {
        CompletableFuture<Void> configureFuture = new CompletableFuture<Void>();
        this.threadContext.execute(() -> {
            FollowerRole followerRole;
            ElectionTimer patt1$temp;
            this.electionConfig.setNodePriority(newPriority);
            RaftRole patt0$temp = this.role;
            if (patt0$temp instanceof FollowerRole && (patt1$temp = (followerRole = (FollowerRole)patt0$temp).getElectionTimer()) instanceof PriorityElectionTimer) {
                PriorityElectionTimer priorityElectionTimer = (PriorityElectionTimer)patt1$temp;
                priorityElectionTimer.setNodePriority(newPriority);
            }
            configureFuture.complete(null);
        });
        return configureFuture;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public void updateState(State newState) {
        if (this.state != newState) {
            this.state = newState;
            this.stateChangeListeners.forEach(l -> l.accept(this.state));
        }
    }

    public int getSnapshotChunkSize() {
        return this.snapshotChunkSize;
    }

    public CompletableFuture<Collection<Path>> getTailSegments(long index) {
        CompletableFuture<Collection<Path>> fut = new CompletableFuture<Collection<Path>>();
        this.threadContext.execute(() -> {
            SortedMap<Long, Path> segments = this.raftLog.getTailSegments(index);
            fut.complete(segments.values());
        });
        return fut;
    }

    private static /* synthetic */ void lambda$handleRequestOnContext$29(Supplier responseBuilder, CompletableFuture future, RaftError error) {
        RaftResponse response = (RaftResponse)((RaftResponse.Builder)responseBuilder.get()).withStatus(RaftResponse.Status.ERROR).withError(error).build();
        LOGGER.trace("Sending {}", (Object)response);
        future.complete(response);
    }

    private static /* synthetic */ void lambda$handleRequestOnContext$28(Supplier function, CompletableFuture future, Void ignore) {
        ((CompletableFuture)function.get()).whenComplete((response, error) -> {
            if (error == null) {
                future.complete(response);
            } else {
                future.completeExceptionally((Throwable)error);
            }
        });
    }

    public static enum State {
        ACTIVE,
        READY,
        LEFT;

    }

    private static enum MissedSnapshotReplicationEvents {
        NONE,
        STARTED,
        COMPLETED;

    }

    final class AwaitingReadyCommitListener
    implements RaftCommitListener {
        private final Logger throttledLogger = new ThrottledLogger(LOGGER, Duration.ofSeconds(30L));

        AwaitingReadyCommitListener() {
        }

        @Override
        public void onCommit(long index) {
            RaftContext.this.setFirstCommitIndex(index);
            if (index >= RaftContext.this.firstCommitIndex) {
                LOGGER.info("Commit index is {}. RaftServer is ready", (Object)index);
                RaftContext.this.updateState(State.READY);
                RaftContext.this.removeCommitListener(this);
            } else {
                this.throttledLogger.info("Commit index is {}. RaftServer is ready only after it has committed events up to index {}", (Object)RaftContext.this.commitIndex, (Object)RaftContext.this.firstCommitIndex);
            }
        }
    }
}

