/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.impl;

import io.atomix.raft.ElectionTimer;
import io.atomix.utils.concurrent.Scheduled;
import io.atomix.utils.concurrent.ThreadContext;
import java.time.Duration;
import org.slf4j.Logger;

public class PriorityElectionTimer
implements ElectionTimer {
    private Scheduled electionTimer;
    private final Duration electionTimeout;
    private final ThreadContext threadContext;
    private final Runnable triggerElection;
    private final Logger log;
    private final int initialTargetPriority;
    private int nodePriority;
    private int targetPriority;

    public PriorityElectionTimer(Duration electionTimeout, ThreadContext threadContext, Runnable triggerElection, Logger log, int initialTargetPriority, int nodePriority) {
        this.electionTimeout = electionTimeout;
        this.threadContext = threadContext;
        this.triggerElection = triggerElection;
        this.log = log;
        this.initialTargetPriority = initialTargetPriority;
        this.nodePriority = nodePriority;
        this.targetPriority = initialTargetPriority;
    }

    @Override
    public void reset() {
        this.cancel();
        this.electionTimer = this.threadContext.schedule(this.electionTimeout, this::onElectionTimeout);
        this.targetPriority = this.initialTargetPriority;
    }

    @Override
    public void cancel() {
        if (this.electionTimer != null) {
            this.electionTimer.cancel();
        }
    }

    public void setNodePriority(int newPriority) {
        this.nodePriority = newPriority;
    }

    private void onElectionTimeout() {
        Duration pollTimeout = this.electionTimeout;
        if (this.nodePriority >= this.targetPriority) {
            this.electionTimer = this.threadContext.schedule(pollTimeout, () -> {
                this.log.debug("Failed to poll a majority of the cluster in {}", (Object)pollTimeout);
                this.reset();
            });
            this.triggerElection.run();
        } else {
            this.log.debug("Node priority {} < target priority {}. Not triggering election.", (Object)this.nodePriority, (Object)this.targetPriority);
            this.electionTimer = this.threadContext.schedule(pollTimeout, () -> {
                --this.targetPriority;
                this.onElectionTimeout();
            });
        }
    }
}

