/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.impl;

import io.atomix.raft.metrics.RaftServiceMetrics;
import io.atomix.raft.storage.log.RaftLog;
import io.atomix.utils.concurrent.ThreadContext;
import io.camunda.zeebe.snapshots.PersistedSnapshotStore;
import io.camunda.zeebe.util.CloseableSilently;
import java.util.concurrent.Executor;
import org.agrona.LangUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogCompactor {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogCompactor.class);
    private final ThreadContext threadContext;
    private final RaftLog log;
    private final int replicationThreshold;
    private final RaftServiceMetrics metrics;
    private volatile long compactableIndex;

    public LogCompactor(ThreadContext threadContext, RaftLog log, int replicationThreshold, RaftServiceMetrics metrics) {
        this.threadContext = threadContext;
        this.log = log;
        this.replicationThreshold = replicationThreshold;
        this.metrics = metrics;
    }

    public long getCompactableIndex() {
        return this.compactableIndex;
    }

    void setCompactableIndex(long index) {
        LOGGER.trace("Updated compactable index to {}", (Object)index);
        this.compactableIndex = index;
    }

    public boolean compact() {
        return this.compact(this.compactableIndex - (long)this.replicationThreshold);
    }

    public boolean compactIgnoringReplicationThreshold() {
        return this.compact(this.compactableIndex);
    }

    public void compactFromSnapshots(PersistedSnapshotStore snapshotStore) {
        snapshotStore.getCompactionBound().onComplete(this::onSnapshotCompactionBound, (Executor)this.threadContext);
    }

    private boolean compact(long index) {
        boolean bl;
        block8: {
            this.threadContext.checkThread();
            CloseableSilently ignored = this.metrics.compactionTime();
            try {
                boolean compacted = this.log.deleteUntil(index);
                LOGGER.debug("Compacted log up to index {}", (Object)index);
                bl = compacted;
                if (ignored == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error("Failed to compact up to index {}", (Object)index, (Object)e);
                    LangUtil.rethrowUnchecked((Throwable)e);
                    return false;
                }
            }
            ignored.close();
        }
        return bl;
    }

    private void onSnapshotCompactionBound(Long index, Throwable error) {
        if (error != null) {
            LOGGER.error("Expected to compact logs, but could not the compaction bound from the snapshot store", error);
            return;
        }
        LOGGER.debug("Scheduling log compaction up to index {}", (Object)index);
        this.setCompactableIndex(index);
        this.compact();
    }
}

