/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.cluster.MemberId;
import io.atomix.raft.RaftRoleChangeListener;
import io.atomix.raft.RaftServer;
import io.atomix.raft.RaftThreadContextFactory;
import io.atomix.raft.cluster.RaftCluster;
import io.atomix.raft.cluster.RaftMember;
import io.atomix.raft.impl.DefaultRaftSingleThreadContextFactory;
import io.atomix.raft.impl.RaftContext;
import io.atomix.raft.impl.ReconfigurationHelper;
import io.atomix.raft.storage.RaftStorage;
import io.camunda.zeebe.util.health.FailureListener;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRaftServer
implements RaftServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRaftServer.class);
    protected final RaftContext context;
    private final AtomicReference<CompletableFuture<RaftServer>> openFutureRef = new AtomicReference();
    private volatile boolean started;
    private volatile boolean stopped = false;

    public DefaultRaftServer(RaftContext context) {
        this.context = (RaftContext)Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name()).toString();
    }

    @Override
    public String name() {
        return this.context.getName();
    }

    @Override
    public RaftCluster cluster() {
        return this.context.getCluster();
    }

    @Override
    public void addRoleChangeListener(RaftRoleChangeListener listener) {
        this.context.addRoleChangeListener(listener);
    }

    @Override
    public void removeRoleChangeListener(RaftRoleChangeListener listener) {
        this.context.removeRoleChangeListener(listener);
    }

    @Override
    public void addFailureListener(FailureListener listener) {
        this.context.addFailureListener(listener);
    }

    @Override
    public void removeFailureListener(FailureListener listener) {
        this.context.removeFailureListener(listener);
    }

    @Override
    public CompletableFuture<RaftServer> bootstrap(Collection<MemberId> cluster) {
        return this.start(() -> this.cluster().bootstrap(cluster));
    }

    @Override
    public CompletableFuture<RaftServer> join(Collection<MemberId> cluster) {
        return this.start(() -> this.cluster().join(cluster));
    }

    @Override
    public CompletableFuture<RaftServer> leave() {
        return new ReconfigurationHelper(this.context).leave().thenApply(v -> this);
    }

    @Override
    public CompletableFuture<RaftServer> promote() {
        return new ReconfigurationHelper(this.context).anoint().thenApply(v -> this);
    }

    @Override
    public CompletableFuture<RaftServer> forceConfigure(Map<MemberId, RaftMember.Type> membersToRetain) {
        return new ReconfigurationHelper(this.context).forceConfigure(membersToRetain).thenApply(v -> this);
    }

    @Override
    public CompletableFuture<Void> reconfigurePriority(int newPriority) {
        return this.context.reconfigurePriority(newPriority);
    }

    @Override
    public CompletableFuture<Void> flushLog() {
        return this.context.flushLog();
    }

    @Override
    public CompletableFuture<Void> shutdown() {
        if (this.stopped) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.runAsync(() -> {
            this.stopped = true;
            this.started = false;
            this.context.transition(RaftServer.Role.INACTIVE);
            this.context.close();
        }, (Executor)this.context.getThreadContext());
    }

    @Override
    public RaftContext getContext() {
        return this.context;
    }

    @Override
    public long getTerm() {
        return this.context.getTerm();
    }

    @Override
    public RaftServer.Role getRole() {
        return this.context.getRole();
    }

    @Override
    public boolean isRunning() {
        return this.started && !this.stopped && this.context.isRunning();
    }

    @Override
    public CompletableFuture<Void> stepDown() {
        return CompletableFuture.runAsync(() -> this.context.transition(RaftServer.Role.FOLLOWER), (Executor)this.context.getThreadContext());
    }

    private CompletableFuture<RaftServer> start(Supplier<CompletableFuture<Void>> joiner) {
        if (this.started) {
            return CompletableFuture.completedFuture(this);
        }
        if (this.openFutureRef.compareAndSet(null, new CompletableFuture())) {
            this.stopped = false;
            joiner.get().whenComplete((result, error) -> {
                if (error == null) {
                    LOGGER.info("Server join completed. Waiting for the server to be READY");
                    this.context.addStateChangeListener(new StartedStateListener(this));
                } else {
                    this.openFutureRef.get().completeExceptionally((Throwable)error);
                }
            });
        }
        return this.openFutureRef.get().whenComplete((result, error) -> {
            if (error == null) {
                LOGGER.debug("Server started successfully!");
            } else if (error instanceof RaftServer.CancelledBootstrapException) {
                LOGGER.debug("Server bootstrap cancelled", error);
            } else {
                LOGGER.warn("Failed to start server", error);
            }
        });
    }

    private final class StartedStateListener
    implements Consumer<RaftContext.State> {
        private final RaftServer raftServer;

        private StartedStateListener(RaftServer raftServer) {
            this.raftServer = raftServer;
        }

        @Override
        public void accept(RaftContext.State state) {
            if (state == RaftContext.State.READY) {
                DefaultRaftServer.this.started = true;
                DefaultRaftServer.this.openFutureRef.get().complete(this.raftServer);
                DefaultRaftServer.this.context.removeStateChangeListener(this);
            } else if (state == RaftContext.State.LEFT) {
                DefaultRaftServer.this.started = false;
                DefaultRaftServer.this.openFutureRef.get().completeExceptionally(new RaftServer.CancelledBootstrapException("Server left the replication group while waiting for ready."));
                DefaultRaftServer.this.context.removeStateChangeListener(this);
            }
        }
    }

    public static class Builder
    extends RaftServer.Builder {
        public Builder(MemberId localMemberId) {
            super(localMemberId);
        }

        public RaftServer build() {
            if (this.name == null) {
                this.name = (String)((Object)this.localMemberId.id());
            }
            if (this.storage == null) {
                this.storage = RaftStorage.builder(this.meterRegistry).build();
            }
            RaftThreadContextFactory singleThreadFactory = this.threadContextFactory == null ? new DefaultRaftSingleThreadContextFactory() : this.threadContextFactory;
            Supplier randomSupplier = this.randomFactory == null ? Random::new : this.randomFactory;
            RaftContext raft = new RaftContext(this.name, this.partitionId, this.localMemberId, this.membershipService, this.protocol, this.storage, singleThreadFactory, randomSupplier, this.electionConfig, this.partitionConfig, this.meterRegistry);
            raft.setEntryValidator(this.entryValidator);
            return new DefaultRaftServer(raft);
        }
    }
}

