/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import io.atomix.cluster.messaging.impl.MessagingProtocol;
import io.atomix.cluster.messaging.impl.MessagingProtocolV1;
import io.atomix.cluster.messaging.impl.MessagingProtocolV2;
import io.atomix.utils.net.Address;
import java.util.stream.Stream;

public enum ProtocolVersion {
    V1(1){

        @Override
        public MessagingProtocol createProtocol(Address address) {
            return new MessagingProtocolV1(address);
        }
    }
    ,
    V2(2){

        @Override
        public MessagingProtocol createProtocol(Address address) {
            return new MessagingProtocolV2(address);
        }
    };

    private final short version;

    private ProtocolVersion(int version) {
        this.version = (short)version;
    }

    public static ProtocolVersion valueOf(int version) {
        return Stream.of(ProtocolVersion.values()).filter(v -> v.version() == version).findFirst().orElse(null);
    }

    public static ProtocolVersion latest() {
        return ProtocolVersion.values()[ProtocolVersion.values().length - 1];
    }

    public short version() {
        return this.version;
    }

    public abstract MessagingProtocol createProtocol(Address var1);
}

