/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import com.google.common.collect.Maps;
import io.atomix.utils.net.Address;
import io.camunda.zeebe.util.collection.Tuple;
import io.netty.channel.Channel;
import java.net.InetAddress;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChannelPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelPool.class);
    private final Function<Address, CompletableFuture<Channel>> factory;
    private final Map<Tuple<Address, InetAddress>, Map<String, CompletableFuture<Channel>>> channels = Maps.newConcurrentMap();

    ChannelPool(Function<Address, CompletableFuture<Channel>> factory) {
        this.factory = factory;
    }

    private Map<String, CompletableFuture<Channel>> getChannelPool(Address address, InetAddress inetAddress) {
        return this.channels.computeIfAbsent((Tuple<Address, InetAddress>)new Tuple((Object)address, (Object)inetAddress), k -> Maps.newConcurrentMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<Channel> getChannel(Address address, String messageType) {
        CompletableFuture<Channel> finalFuture;
        InetAddress inetAddress = address.getAddress();
        Map<String, CompletableFuture<Channel>> channelPool = this.getChannelPool(address, inetAddress);
        CompletableFuture<Channel> channelFuture = channelPool.get(messageType);
        if (channelFuture == null || channelFuture.isCompletedExceptionally()) {
            Map<String, CompletableFuture<Channel>> map = channelPool;
            synchronized (map) {
                channelFuture = channelPool.get(messageType);
                if (channelFuture == null || channelFuture.isCompletedExceptionally()) {
                    LOGGER.debug("Connecting to {}", (Object)address);
                    finalFuture = channelFuture = this.factory.apply(address);
                    channelFuture.whenComplete((channel, error) -> {
                        if (error == null) {
                            LOGGER.debug("Connected to {}", (Object)channel.remoteAddress());
                            channel.closeFuture().addListener(closed -> {
                                Map map = channelPool;
                                synchronized (map) {
                                    ChannelPool.removeChannel(channelPool, messageType, finalFuture);
                                }
                            });
                        } else {
                            LOGGER.debug("Failed to connect to {}", (Object)address, error);
                        }
                    });
                    channelPool.put(messageType, channelFuture);
                }
            }
        }
        CompletableFuture<Channel> future = new CompletableFuture<Channel>();
        finalFuture = channelFuture;
        finalFuture.whenComplete((channel, error) -> {
            if (error == null) {
                if (!channel.isActive()) {
                    CompletableFuture<Channel> currentFuture;
                    Map map = channelPool;
                    synchronized (map) {
                        currentFuture = (CompletableFuture<Channel>)channelPool.get(messageType);
                        if (currentFuture == finalFuture) {
                            channelPool.put(messageType, null);
                        } else if (currentFuture == null) {
                            currentFuture = this.factory.apply(address);
                            currentFuture.whenComplete(this::logConnection);
                            channelPool.put(messageType, currentFuture);
                        }
                    }
                    if (currentFuture == finalFuture) {
                        this.getChannel(address, messageType).whenComplete((recursiveResult, recursiveError) -> this.completeFuture(future, (Channel)recursiveResult, (Throwable)recursiveError));
                    } else {
                        currentFuture.whenComplete((recursiveResult, recursiveError) -> this.completeFuture(future, (Channel)recursiveResult, (Throwable)recursiveError));
                    }
                } else {
                    future.complete((Channel)channel);
                }
            } else {
                future.completeExceptionally((Throwable)error);
            }
        });
        return future;
    }

    private static void removeChannel(Map<String, CompletableFuture<Channel>> channelPool, String messageType, CompletableFuture<Channel> finalFuture) {
        CompletableFuture<Channel> currentFuture = channelPool.get(messageType);
        if (finalFuture == currentFuture) {
            channelPool.remove(messageType);
        }
    }

    private void completeFuture(CompletableFuture<Channel> future, Channel recursiveResult, Throwable recursiveError) {
        if (recursiveError == null) {
            future.complete(recursiveResult);
        } else {
            future.completeExceptionally(recursiveError);
        }
    }

    private void logConnection(Channel channel, Throwable e) {
        if (e == null) {
            LOGGER.debug("Connected to {}", (Object)channel.remoteAddress());
        } else {
            LOGGER.debug("Failed to connect to {}", (Object)channel.remoteAddress(), (Object)e);
        }
    }
}

