/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractMessageDecoder
extends ByteToMessageDecoder {
    static final byte[] EMPTY_PAYLOAD = new byte[0];
    private static final Escape ESCAPE = new Escape();
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    AbstractMessageDecoder() {
    }

    static int readInt(ByteBuf buffer) {
        if (buffer.readableBytes() < 5) {
            return AbstractMessageDecoder.readIntSlow(buffer);
        }
        return AbstractMessageDecoder.readIntFast(buffer);
    }

    static int readIntFast(ByteBuf buffer) {
        byte b = buffer.readByte();
        int result = b & 0x7F;
        if ((b & 0x80) != 0) {
            b = buffer.readByte();
            result |= (b & 0x7F) << 7;
            if ((b & 0x80) != 0) {
                b = buffer.readByte();
                result |= (b & 0x7F) << 14;
                if ((b & 0x80) != 0) {
                    b = buffer.readByte();
                    result |= (b & 0x7F) << 21;
                    if ((b & 0x80) != 0) {
                        b = buffer.readByte();
                        result |= (b & 0x7F) << 28;
                    }
                }
            }
        }
        return result;
    }

    static int readIntSlow(ByteBuf buffer) {
        if (buffer.readableBytes() == 0) {
            throw ESCAPE;
        }
        buffer.markReaderIndex();
        byte b = buffer.readByte();
        int result = b & 0x7F;
        if ((b & 0x80) != 0) {
            if (buffer.readableBytes() == 0) {
                buffer.resetReaderIndex();
                throw ESCAPE;
            }
            b = buffer.readByte();
            result |= (b & 0x7F) << 7;
            if ((b & 0x80) != 0) {
                if (buffer.readableBytes() == 0) {
                    buffer.resetReaderIndex();
                    throw ESCAPE;
                }
                b = buffer.readByte();
                result |= (b & 0x7F) << 14;
                if ((b & 0x80) != 0) {
                    if (buffer.readableBytes() == 0) {
                        buffer.resetReaderIndex();
                        throw ESCAPE;
                    }
                    b = buffer.readByte();
                    result |= (b & 0x7F) << 21;
                    if ((b & 0x80) != 0) {
                        if (buffer.readableBytes() == 0) {
                            buffer.resetReaderIndex();
                            throw ESCAPE;
                        }
                        b = buffer.readByte();
                        result |= (b & 0x7F) << 28;
                    }
                }
            }
        }
        return result;
    }

    static long readLong(ByteBuf buffer) {
        if (buffer.readableBytes() < 9) {
            return AbstractMessageDecoder.readLongSlow(buffer);
        }
        return AbstractMessageDecoder.readLongFast(buffer);
    }

    static long readLongFast(ByteBuf buffer) {
        byte b = buffer.readByte();
        long result = b & 0x7F;
        if ((b & 0x80) != 0) {
            b = buffer.readByte();
            result |= (long)((b & 0x7F) << 7);
            if ((b & 0x80) != 0) {
                b = buffer.readByte();
                result |= (long)((b & 0x7F) << 14);
                if ((b & 0x80) != 0) {
                    b = buffer.readByte();
                    result |= (long)((b & 0x7F) << 21);
                    if ((b & 0x80) != 0) {
                        b = buffer.readByte();
                        result |= (long)(b & 0x7F) << 28;
                        if ((b & 0x80) != 0) {
                            b = buffer.readByte();
                            result |= (long)(b & 0x7F) << 35;
                            if ((b & 0x80) != 0) {
                                b = buffer.readByte();
                                result |= (long)(b & 0x7F) << 42;
                                if ((b & 0x80) != 0) {
                                    b = buffer.readByte();
                                    result |= (long)(b & 0x7F) << 49;
                                    if ((b & 0x80) != 0) {
                                        b = buffer.readByte();
                                        result |= (long)b << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    static long readLongSlow(ByteBuf buffer) {
        if (buffer.readableBytes() == 0) {
            throw ESCAPE;
        }
        buffer.markReaderIndex();
        byte b = buffer.readByte();
        long result = b & 0x7F;
        if ((b & 0x80) != 0) {
            if (buffer.readableBytes() == 0) {
                buffer.resetReaderIndex();
                throw ESCAPE;
            }
            b = buffer.readByte();
            result |= (long)((b & 0x7F) << 7);
            if ((b & 0x80) != 0) {
                if (buffer.readableBytes() == 0) {
                    buffer.resetReaderIndex();
                    throw ESCAPE;
                }
                b = buffer.readByte();
                result |= (long)((b & 0x7F) << 14);
                if ((b & 0x80) != 0) {
                    if (buffer.readableBytes() == 0) {
                        buffer.resetReaderIndex();
                        throw ESCAPE;
                    }
                    b = buffer.readByte();
                    result |= (long)((b & 0x7F) << 21);
                    if ((b & 0x80) != 0) {
                        if (buffer.readableBytes() == 0) {
                            buffer.resetReaderIndex();
                            throw ESCAPE;
                        }
                        b = buffer.readByte();
                        result |= (long)(b & 0x7F) << 28;
                        if ((b & 0x80) != 0) {
                            if (buffer.readableBytes() == 0) {
                                buffer.resetReaderIndex();
                                throw ESCAPE;
                            }
                            b = buffer.readByte();
                            result |= (long)(b & 0x7F) << 35;
                            if ((b & 0x80) != 0) {
                                if (buffer.readableBytes() == 0) {
                                    buffer.resetReaderIndex();
                                    throw ESCAPE;
                                }
                                b = buffer.readByte();
                                result |= (long)(b & 0x7F) << 42;
                                if ((b & 0x80) != 0) {
                                    if (buffer.readableBytes() == 0) {
                                        buffer.resetReaderIndex();
                                        throw ESCAPE;
                                    }
                                    b = buffer.readByte();
                                    result |= (long)(b & 0x7F) << 49;
                                    if ((b & 0x80) != 0) {
                                        if (buffer.readableBytes() == 0) {
                                            buffer.resetReaderIndex();
                                            throw ESCAPE;
                                        }
                                        b = buffer.readByte();
                                        result |= (long)b << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    static String readString(ByteBuf buffer, int length) {
        if (buffer.isDirect()) {
            String result = buffer.toString(buffer.readerIndex(), length, StandardCharsets.UTF_8);
            buffer.skipBytes(length);
            return result;
        }
        if (buffer.hasArray()) {
            String result = new String(buffer.array(), buffer.arrayOffset() + buffer.readerIndex(), length, StandardCharsets.UTF_8);
            buffer.skipBytes(length);
            return result;
        }
        byte[] array = new byte[length];
        buffer.readBytes(array);
        return new String(array, StandardCharsets.UTF_8);
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
        try {
            this.log.error("Exception inside channel handling pipeline.", cause);
        }
        finally {
            context.close();
        }
    }

    static class Escape
    extends RuntimeException {
        Escape() {
        }
    }
}

