/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.impl;

import io.atomix.cluster.Member;
import io.atomix.utils.Version;
import java.util.Objects;

public final class StatefulMember
extends Member {
    private final Version version;
    private volatile boolean active;
    private volatile boolean reachable;

    public StatefulMember(Member member, Version version) {
        super(member.id(), member.address(), member.zone(), member.rack(), member.host(), member.properties());
        this.version = version;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.version);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatefulMember that = (StatefulMember)o;
        return this.version.equals((Object)that.version);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isReachable() {
        return this.reachable;
    }

    @Override
    public Version version() {
        return this.version;
    }

    void setReachable(boolean reachable) {
        this.reachable = reachable;
    }
}

