/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.discovery;

import io.atomix.cluster.Node;
import io.atomix.cluster.discovery.BootstrapDiscoveryConfig;
import io.atomix.cluster.discovery.BootstrapDiscoveryProvider;
import io.atomix.cluster.discovery.NodeDiscoveryBuilder;
import io.atomix.cluster.discovery.NodeDiscoveryProvider;
import io.atomix.utils.net.Address;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BootstrapDiscoveryBuilder
extends NodeDiscoveryBuilder {
    private final BootstrapDiscoveryConfig config = new BootstrapDiscoveryConfig();

    public BootstrapDiscoveryBuilder withNodes(Address ... nodes) {
        return this.withNodes(Stream.of(nodes).map(address -> Node.builder().withAddress((Address)address).build()).collect(Collectors.toSet()));
    }

    public BootstrapDiscoveryBuilder withNodes(Collection<Node> locations) {
        this.config.setNodes(locations.stream().map(Node::config).collect(Collectors.toList()));
        return this;
    }

    public NodeDiscoveryProvider build() {
        return new BootstrapDiscoveryProvider(this.config);
    }
}

